/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRules;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.CustomExternalClassSupport;
import com.tplus.transform.runtime.CustomFieldValidationSupport;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldValidationException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.Locator;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Validator;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.xml.XPathValidationSupport;
import com.tplus.transform.runtime.xml.XPathValidationSupportImpl;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractValidationRules
extends AbstractRules
implements Validator {
    public static final String MESSAGE_NAME = "Message";
    protected CustomFieldValidationSupport fieldValidationSupport;
    protected CustomExternalClassSupport customExternalClassSupport;
    protected String messageName;
    String currentRule;
    XPathValidationSupport xPathValidationSupport;
    Map prefixes = new HashMap();

    protected AbstractValidationRules() {
        this(null);
    }

    protected AbstractValidationRules(AbstractServiceElement serviceElement) {
        super(serviceElement);
        this.messageName = serviceElement == null ? "" : serviceElement.getEntityName();
        this.setLogger(LogFactory.getValidationLog(serviceElement, this.messageName));
    }

    protected void setup(TransformContext cxt) {
        super.setup(cxt);
        this.currentRule = null;
    }

    protected void teardown(TransformContext cxt) {
        super.teardown(cxt);
        this.currentRule = null;
    }

    protected boolean customValidation(String customClass, Object value, String fldName, DataObject obj) throws TransformException {
        if (this.fieldValidationSupport == null) {
            this.fieldValidationSupport = new CustomFieldValidationSupport(this.getClass().getClassLoader());
        }
        return this.fieldValidationSupport.customValidation(customClass, value, fldName, obj);
    }

    protected Object invokeCustomExternalClass(String className, Object[] args, TransformContext cxt) throws TransformException {
        if (this.customExternalClassSupport == null) {
            this.customExternalClassSupport = new CustomExternalClassSupport(this.getClass().getClassLoader());
        }
        return this.customExternalClassSupport.invoke(className, args, cxt);
    }

    protected void throwFieldInvalid(String validationName, String fieldName) throws FieldValidationException {
        FieldValidationException fve = FieldValidationException.createFieldValidationExceptionFormatted("SRT201", new String[]{validationName, fieldName});
        fve.setField(fieldName);
        throw fve;
    }

    protected void throwFieldInvalid(FieldValidationException e, String validationMessage, String validationName, String errorCode, String severity, boolean cascadable, DataObject object, int index) throws TransformException {
        if (validationMessage != null) {
            this.throwFieldInvalid(validationMessage, validationName, errorCode, severity, cascadable, object, index);
        } else {
            try {
                String qualifiedFieldName = MESSAGE_NAME;
                String id = null;
                if (object != null) {
                    if (index == -1) {
                        qualifiedFieldName = object.getQualifiedName();
                        id = object.getID();
                    } else {
                        qualifiedFieldName = object.getQualifiedName(index);
                        id = object.getFieldID(index);
                    }
                }
                e.setErrorCode(errorCode);
                e.setContextProperty("Internal-Code", validationName);
                e.setField(qualifiedFieldName);
                e.setFieldID(id);
                this.setLocation(e, object, index);
                e.setCascadable(cascadable);
                e.setSeverity(severity);
                e.setErrorType("Validation");
                this.getExceptionHandler().onException(e);
            }
            catch (FieldNotFoundException fne) {
                throw e;
            }
        }
    }

    private void setLocation(TransformException e, DataObject object, int index) {
        if (object != null) {
            LocationInfo locationInfo = object.getLocationInfo();
            Locator locator = index == -1 ? locationInfo.getLocation() : locationInfo.getFieldLocation(index);
            if (locator != null) {
                e.setContextProperty("line", Parsing.toString(locator.getLine()));
                e.setContextProperty("column", Parsing.toString(locator.getColumn()));
            }
        }
    }

    protected void throwFieldInvalid(FieldValidationException ex, String validationName, String errorCode, String severity, boolean cascadable, DataObject object, int index) throws TransformException {
        this.throwFieldInvalid(ex, null, validationName, errorCode, severity, cascadable, object, index);
    }

    public void throwFieldInvalid(String validationMessage, String validationName, String errorCode, String severity, boolean cascadable, String qualifiedFieldName, String fieldId, DataObject object, int index) throws TransformException {
        this.throwFieldInvalid(validationMessage, validationName, errorCode, severity, cascadable, qualifiedFieldName, fieldId, object, index, null);
    }

    public void throwFieldInvalid(String validationMessage, String validationName, String errorCode, String severity, boolean cascadable, String qualifiedFieldName, String fieldId, DataObject object, int index, Throwable chainedException) throws TransformException {
        FieldValidationException e;
        if (validationMessage == null) {
            e = qualifiedFieldName == null || qualifiedFieldName.equals(MESSAGE_NAME) ? FieldValidationException.createFieldValidationExceptionFormatted("SRT201A", new Object[]{validationName, qualifiedFieldName}) : FieldValidationException.createFieldValidationExceptionFormatted("SRT201", new Object[]{validationName, qualifiedFieldName});
            e.setField(qualifiedFieldName);
        } else {
            e = new FieldValidationException(validationMessage, qualifiedFieldName);
        }
        e.setErrorCode(errorCode);
        e.setContextProperty("Internal-Code", validationName);
        e.setFieldID(fieldId);
        this.setLocation(e, object, index);
        e.setCascadable(cascadable);
        e.setSeverity(severity);
        e.setErrorType("Validation");
        if (chainedException != null) {
            e.setDetail(chainedException);
        }
        this.getExceptionHandler().onException(e);
    }

    protected void throwFieldInvalid(String validationMessage, String validationName, String errorCode, String severity, boolean cascadable, DataObject object, int index) throws TransformException {
        try {
            String qualifiedFieldName = MESSAGE_NAME;
            String id = null;
            if (object != null) {
                if (index == -1) {
                    qualifiedFieldName = object.getQualifiedName();
                    id = object.getID();
                } else {
                    qualifiedFieldName = object.getQualifiedName(index);
                    id = object.getFieldID(index);
                }
            }
            this.throwFieldInvalid(validationMessage, validationName, errorCode, severity, cascadable, qualifiedFieldName, id, object, index, null);
        }
        catch (FieldNotFoundException e) {
            FieldValidationException fve = FieldValidationException.createFieldValidationExceptionFormatted("SRT202", validationName);
            fve.setField("");
            throw fve;
        }
    }

    protected void throwFieldInvalid(String validationName, String errorCode, String severity, boolean cascadable, DataObject object, int index) throws TransformException {
        this.throwFieldInvalid((String)null, validationName, errorCode, severity, cascadable, object, index);
    }

    public String getCurrentRule() {
        return this.currentRule;
    }

    public final void setCurrentRule(String currentRule) {
        this.currentRule = currentRule;
        if (this.isTraceEnabled()) {
            this.getLogger().trace("Validation Rule " + currentRule);
        }
    }

    protected void handleUnexpectedException(RuntimeException e) {
        TransformRuntimeException tre = e instanceof TransformRuntimeException ? (TransformRuntimeException)e : new TransformRuntimeException("Unexpected exception while executing validation", e);
        if (this.currentRule != null) {
            tre.setContextProperty("Validation-Rule", this.currentRule);
        }
        tre.setContextProperty("Error-Type", "Validation");
        throw tre;
    }

    public void startNamespaceMapping(String prefix, String uri) {
        this.prefixes.put(prefix, uri);
    }

    public void addXPathValidation(String context, String rule, String actionMessage, String validationName, String errorCode, String severity, boolean cascadable) {
        this.createXPathValidationSupport();
        this.xPathValidationSupport.addXPathValidation(context, rule, actionMessage, validationName, errorCode, severity, cascadable);
    }

    private void createXPathValidationSupport() {
        if (this.xPathValidationSupport == null) {
            this.xPathValidationSupport = new XPathValidationSupportImpl(this, this.prefixes);
        }
    }

    public void executeXPathValidations(DataObject root) throws TransformException {
        if (this.xPathValidationSupport != null && this.xPathValidationSupport.hasValidations()) {
            this.xPathValidationSupport.executeXPathValidations(root);
        }
    }

    public abstract void validate(DataObject var1, ExceptionHandler var2, TransformContext var3) throws TransformException;
}

