/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.FieldValueException;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformNullValueException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.collection.BigDecimalList;
import com.tplus.transform.runtime.collection.BigIntegerList;
import com.tplus.transform.runtime.collection.BinaryList;
import com.tplus.transform.runtime.collection.BooleanList;
import com.tplus.transform.runtime.collection.CalendarList;
import com.tplus.transform.runtime.collection.CharList;
import com.tplus.transform.runtime.collection.DateList;
import com.tplus.transform.runtime.collection.DoubleList;
import com.tplus.transform.runtime.collection.FloatList;
import com.tplus.transform.runtime.collection.IntList;
import com.tplus.transform.runtime.collection.LongList;
import com.tplus.transform.runtime.collection.RawMessageList;
import com.tplus.transform.runtime.collection.ScaledDecimalList;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.collection.ValueList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractVariant
implements Variant {
    final DesignerType type;

    protected AbstractVariant(DesignerType type) {
        this.type = type;
    }

    public DesignerType getType() {
        return this.type;
    }

    public String toText() {
        if (this.type == DesignerType.DESIGNER_STRING_TYPE) {
            return (String)this.getValue();
        }
        return this.type.format(this.getValue());
    }

    public int toInt() {
        return this.throwTypeMismatch(DesignerType.DESIGNER_INT_TYPE);
    }

    public long toLong() {
        return this.throwTypeMismatch(DesignerType.DESIGNER_LONG_TYPE);
    }

    public double toDouble() {
        return this.throwTypeMismatch(DesignerType.DESIGNER_DOUBLE_TYPE);
    }

    public float toFloat() {
        return this.throwTypeMismatch(DesignerType.DESIGNER_FLOAT_TYPE);
    }

    public boolean toBoolean() {
        this.throwTypeMismatch(DesignerType.DESIGNER_BOOLEAN_TYPE);
        return false;
    }

    public char toChar() {
        this.throwTypeMismatch(DesignerType.DESIGNER_CHAR_TYPE);
        return '\u0000';
    }

    public Date toDate() {
        this.throwTypeMismatch(DesignerType.DESIGNER_DATE_ONLY_TYPE);
        return null;
    }

    public Calendar toISODate() {
        this.throwTypeMismatch(DesignerType.DESIGNER_ISO_DATE_TYPE);
        return null;
    }

    public BigInteger toBigInteger() {
        this.throwTypeMismatch(DesignerType.DESIGNER_BIG_INT_TYPE);
        return null;
    }

    public BigDecimal toBigDecimal() {
        this.throwTypeMismatch(DesignerType.DESIGNER_BIG_DECIMAL_TYPE);
        return null;
    }

    public ScaledDecimal toScaledDecimal() {
        this.throwTypeMismatch(DesignerType.DESIGNER_SCALED_DECIMAL_TYPE);
        return null;
    }

    public RawMessage toRawMessage() {
        this.throwTypeMismatch(DesignerType.DESIGNER_RAW_MESSAGE_TYPE);
        return null;
    }

    public byte[] toBinary() {
        this.throwTypeMismatch(DesignerType.DESIGNER_BINARY_TYPE);
        return null;
    }

    public DataObjectSection getSection() {
        this.throwTypeMismatch(DesignerType.DESIGNER_SECTION_TYPE);
        return null;
    }

    public DataObject getDataObject() {
        this.throwTypeMismatch(DesignerType.DESIGNER_DATAOBJECT_TYPE);
        return null;
    }

    public ValueList toList() {
        this.throwTypeMismatch(DesignerType.DESIGNER_STRING_LIST_TYPE);
        return null;
    }

    public void setValue(Object value) throws FieldValueException {
        throw new FieldValueException("Attempt to change an immutable variant object");
    }

    public void setNull() throws FieldValueException {
        throw new FieldValueException("Attempt to change an immutable variant object");
    }

    public boolean isMutable() {
        return false;
    }

    protected void ensureNotNull() {
        if (this.isNull()) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT500", "Variant");
        }
    }

    protected int throwTypeMismatch(DesignerType toType) {
        FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT116", new Object[]{this.type.toString(), toType.toString()});
        throw ftme;
    }

    public static DesignerType getDesignerType(Object value) {
        if (value instanceof String) {
            return DesignerType.DESIGNER_STRING_TYPE;
        }
        if (value instanceof Character) {
            return DesignerType.DESIGNER_CHAR_TYPE;
        }
        if (value instanceof Integer) {
            return DesignerType.DESIGNER_INT_TYPE;
        }
        if (value instanceof Double) {
            return DesignerType.DESIGNER_DOUBLE_TYPE;
        }
        if (value instanceof Long) {
            return DesignerType.DESIGNER_LONG_TYPE;
        }
        if (value instanceof Float) {
            return DesignerType.DESIGNER_FLOAT_TYPE;
        }
        if (value instanceof Date) {
            return DesignerType.DESIGNER_DATE_TIME_TYPE;
        }
        if (value instanceof Calendar) {
            return DesignerType.DESIGNER_ISO_DATE_TIME_TYPE;
        }
        if (value instanceof Boolean) {
            return DesignerType.DESIGNER_BOOLEAN_TYPE;
        }
        if (value instanceof BigDecimal) {
            return DesignerType.DESIGNER_BIG_DECIMAL_TYPE;
        }
        if (value instanceof BigInteger) {
            return DesignerType.DESIGNER_BIG_INT_TYPE;
        }
        if (value instanceof ScaledDecimal) {
            return DesignerType.DESIGNER_SCALED_DECIMAL_TYPE;
        }
        if (value instanceof byte[]) {
            return DesignerType.DESIGNER_BINARY_TYPE;
        }
        if (value instanceof RawMessage) {
            return DesignerType.DESIGNER_RAW_MESSAGE_TYPE;
        }
        if (value instanceof DataObject) {
            return DesignerType.DESIGNER_DATAOBJECT_TYPE;
        }
        if (value instanceof DataObjectSection) {
            return DesignerType.DESIGNER_SECTION_TYPE;
        }
        if (value instanceof ValueList) {
            if (value instanceof IntList) {
                return DesignerType.DESIGNER_INT_LIST_TYPE;
            }
            if (value instanceof LongList) {
                return DesignerType.DESIGNER_LONG_LIST_TYPE;
            }
            if (value instanceof FloatList) {
                return DesignerType.DESIGNER_FLOAT_LIST_TYPE;
            }
            if (value instanceof DoubleList) {
                return DesignerType.DESIGNER_DOUBLE_LIST_TYPE;
            }
            if (value instanceof CharList) {
                return DesignerType.DESIGNER_CHAR_LIST_TYPE;
            }
            if (value instanceof BooleanList) {
                return DesignerType.DESIGNER_BOOLEAN_LIST_TYPE;
            }
            if (value instanceof StringList) {
                return DesignerType.DESIGNER_STRING_LIST_TYPE;
            }
            if (value instanceof DateList) {
                return DesignerType.DESIGNER_DATE_TIME_LIST_TYPE;
            }
            if (value instanceof BigIntegerList) {
                return DesignerType.DESIGNER_BIG_INT_LIST_TYPE;
            }
            if (value instanceof BigDecimalList) {
                return DesignerType.DESIGNER_BIG_DECIMAL_LIST_TYPE;
            }
            if (value instanceof ScaledDecimalList) {
                return DesignerType.DESIGNER_SCALED_DECIMAL_LIST_TYPE;
            }
            if (value instanceof CalendarList) {
                return DesignerType.DESIGNER_CHAR_LIST_TYPE;
            }
            if (value instanceof BinaryList) {
                return DesignerType.DESIGNER_BINARY_LIST_TYPE;
            }
            if (value instanceof RawMessageList) {
                return DesignerType.DESIGNER_RAW_MESSAGE_LIST_TYPE;
            }
        }
        return DesignerType.DESIGNER_STRING_TYPE;
    }
}

