/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.FieldParsingException;

public class Base64Binary {
    private static final byte[] decodeMap = Base64Binary.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = Base64Binary.initEncodeMap();

    public static byte[] toBinary(String text) throws FieldParsingException {
        try {
            return Base64Binary.base64StringToBinary(text);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT192", new Object[]{text, String.valueOf(text.length())});
        }
    }

    public static String fromBinary(byte[] bytes) {
        return Base64Binary.binaryToBase64String(bytes);
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map = new byte[128];
        for (i = 0; i < 128; ++i) {
            map[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map[i] = (byte)(i - 48 + 52);
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    private static int calcLength(String text) {
        char ch;
        int len = text.length();
        int base64count = 0;
        for (int i = 0; i < len && (ch = text.charAt(i)) != '='; ++i) {
            if (ch >= '\u0080') {
                return -1;
            }
            if (decodeMap[ch] == -1) continue;
            ++base64count;
        }
        return base64count / 4 * 3 + Math.max(0, base64count % 4 - 1);
    }

    private static byte[] base64StringToBinary(String text) throws FieldParsingException {
        int outlen = Base64Binary.calcLength(text);
        if (outlen == -1) {
            return null;
        }
        byte[] out = new byte[outlen];
        int o = 0;
        int len = text.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            byte v = decodeMap[ch];
            if (v == -1) {
                throw FieldParsingException.createFieldParsingExceptionFormatted("SRT192", new Object[]{text, String.valueOf(text.length())});
            }
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        return out;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map = new char[64];
        for (i = 0; i < 26; ++i) {
            map[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map[i] = (char)(48 + (i - 52));
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    private static String binaryToBase64String(byte[] input) {
        return Base64Binary.binaryToBase64String(input, input.length);
    }

    private static String binaryToBase64String(byte[] input, int len) {
        FastStringBuffer r = new FastStringBuffer(len * 4 / 3);
        block4: for (int i = 0; i < len; i += 3) {
            switch (len - i) {
                case 1: {
                    r.append(Base64Binary.encode(input[i] >> 2));
                    r.append(Base64Binary.encode((input[i] & 3) << 4));
                    r.append("==");
                    continue block4;
                }
                case 2: {
                    r.append(Base64Binary.encode(input[i] >> 2));
                    r.append(Base64Binary.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    r.append(Base64Binary.encode((input[i + 1] & 0xF) << 2));
                    r.append('=');
                    continue block4;
                }
                default: {
                    r.append(Base64Binary.encode(input[i] >> 2));
                    r.append(Base64Binary.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    r.append(Base64Binary.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3));
                    r.append(Base64Binary.encode(input[i + 2] & 0x3F));
                }
            }
        }
        return r.toString();
    }
}

