/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.WeakClassLocal;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.OperationInfo;
import java.util.Collection;
import java.util.List;

public abstract class BaseMessage
extends AbstractServiceElement {
    public static final String PARSE_OPERATION = "parse";
    public static final String VALIDATE_OPERATION = "validate";
    public static final String SERIALIZE_OPERATION = "serialize";
    public static final String OPERATION_SIMPLE_VARIANT = "";
    public static final String OPERATION_VARIANT = "2";
    public static final String MESSAGE_VAR_NAME = "messageObj";
    public static final String RAW_INPUT_VAR_NAME = "input";
    protected OperationInfo parseOperationInfo;
    protected OperationInfo serializeOperationInfo;
    protected OperationInfo validateOperationInfo;
    static WeakClassLocal messageEntityInfo = new WeakClassLocal();

    protected BaseMessage(String entityName, String entityType) {
        super(entityName, entityType);
    }

    protected void init() {
        this.prepareEntityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityInfo prepareEntityInfo() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            EntityInfo entityInfo = (EntityInfo)messageEntityInfo.get(this.getClass());
            if (entityInfo == null) {
                entityInfo = new EntityInfo(this.getEntityName(), this.getEntityType(), this.getClass());
                this.prepareOperations(entityInfo);
                messageEntityInfo.put(this.getClass(), entityInfo);
            }
            this.instanceEntityInfo = entityInfo;
            this.loadOperations(entityInfo);
        }
        return null;
    }

    protected void loadOperations(EntityInfo entityInfo) {
        this.parseOperationInfo = entityInfo.getOperationInfo(PARSE_OPERATION);
        this.validateOperationInfo = entityInfo.getOperationInfo(VALIDATE_OPERATION);
        this.serializeOperationInfo = entityInfo.getOperationInfo(SERIALIZE_OPERATION);
    }

    protected void prepareOperations(EntityInfo entityInfo) {
        OperationInfo parseOperationInfo = new OperationInfo(entityInfo, PARSE_OPERATION);
        entityInfo.addOperation(parseOperationInfo);
        OperationNode parserNode = this.getParserNode();
        List parseLocations = parserNode.getLocations();
        parseOperationInfo.addLocations(parseLocations);
        OperationInfo validateOperationInfo = new OperationInfo(entityInfo, VALIDATE_OPERATION);
        entityInfo.addOperation(validateOperationInfo);
        Collection validators = this.getValidators();
        for (AbstractValidationRules abstractValidationRules : validators) {
            List validateLocations = abstractValidationRules.getLocations();
            validateOperationInfo.addLocations(validateLocations);
        }
        OperationInfo serializeOperationInfo = new OperationInfo(entityInfo, SERIALIZE_OPERATION);
        entityInfo.addOperation(serializeOperationInfo);
    }

    protected abstract Collection getValidators();

    protected abstract OperationNode getParserNode();
}

