/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.SectionMetaInfo;

public abstract class BasicGenericDataObject
extends DataObjectBase {
    public void reset() {
        for (int i = 0; i < this.getDataSize(); ++i) {
            Object o = this.getFieldAtIndex(i);
            if (o instanceof DataObjectSection) {
                ((DataObjectSection)o).reset();
                continue;
            }
            this.setFieldAtIndex(i, null);
        }
    }

    void checkFieldIndex(int index) throws FieldNotFoundException {
        if (index < 0 || index >= this.getFieldCount()) {
            this.throwOutOfRange(index);
        }
    }

    protected final void throwOutOfRange(int index) {
        DataObjectSection dataObjectSection = this.getParentSection();
        FieldNotFoundException e = new FieldNotFoundException("No valid field at index " + index + " for " + (dataObjectSection == null ? "Root" : dataObjectSection.getQualifiedName()));
        throw e;
    }

    public Object getField(int index) throws FieldNotFoundException {
        Object obj = this.getField0(index);
        if (obj == null && this.isDataFieldSection(index)) {
            obj = this.getSection(index);
        }
        return obj;
    }

    public Object getField0(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        return this.getFieldAtIndex(index);
    }

    protected boolean isDataFieldSection(int index) {
        FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfo(index);
        boolean sectionType = fieldMetaInfo.getDesignerType() == DesignerType.DESIGNER_SECTION_TYPE;
        return sectionType;
    }

    boolean isSection(int index) throws FieldNotFoundException {
        return this.getMetaInfo().isSection(index);
    }

    public Object getFieldCheckNull(int index) throws FieldNullException, FieldNotFoundException {
        this.checkFieldIndex(index);
        Object toRet = this.getFieldAtIndex(index);
        if (toRet == null) {
            FieldNullException fne = FieldNullException.createFieldNullExceptionFormatted("SRT600", this.getQualifiedName(index));
            fne.setField(this, index, null);
            throw fne;
        }
        return toRet;
    }

    public DataObjectSection getSection(int index) throws FieldNotFoundException {
        DataObjectSection sec = (DataObjectSection)this.getField0(index);
        if (sec == null) {
            FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfo(index);
            if (!(fieldMetaInfo instanceof SectionMetaInfo)) {
                throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT132", fieldMetaInfo.getName());
            }
            sec = new DataObjectSectionImpl(this, (SectionMetaInfo)fieldMetaInfo);
            try {
                this.setField(index, (Object)sec);
            }
            catch (FieldTypeMismatchException e) {
                throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT132", fieldMetaInfo.getName());
            }
        }
        return sec;
    }

    public boolean isNull(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        if (this.getFieldAtIndex(index) == null) {
            return !this.isDataFieldSection(index);
        }
        return false;
    }

    public void setNull(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        this.setFieldAtIndex(index, null);
    }

    public void setField(int index, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        this.checkFieldIndex(index);
        this.setFieldAtIndex(index, value);
    }

    public DataObject getRootDataObject() {
        DataObjectSection parent = this.getParentSection();
        if (parent != null) {
            return parent.getRootDataObject();
        }
        return this;
    }

    public String getQualifiedName(int index) throws FieldNotFoundException {
        String name = this.getMetaInfo().getFieldName(index);
        DataObjectSection parentSection = this.getParentSection();
        if (parentSection != null) {
            name = parentSection.getQualifiedName() + "." + name;
        }
        return name;
    }

    public boolean isEmpty() {
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            if (this.getFieldAtIndex(i) == null) continue;
            try {
                if (!(this.getFieldAtIndex(i) instanceof DataObjectSection ? !((DataObjectSection)this.getFieldAtIndex(i)).isEmpty() : !this.getMetaInfo().isSynthesized(i))) continue;
                return false;
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    protected abstract int getDataSize();

    protected abstract Object getFieldAtIndex(int var1);

    protected abstract void setFieldAtIndex(int var1, Object var2);
}

