/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BatchOutputWriter;
import com.tplus.transform.runtime.BatchWriter;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.rmi.RemoteException;

public class BatchWriterImpl
implements BatchWriter {
    protected BatchOutputWriter writer;
    private String defaultEncoding;
    transient DataObject lastObject;
    boolean first;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;

    public BatchWriterImpl(BatchOutputWriter writer, String defaultEncoding) {
        this.writer = writer;
        this.defaultEncoding = defaultEncoding;
        this.first = true;
    }

    public void startBatch(OutputDevice outputdevice, TransformContext cxt) throws TransformException, RemoteException {
        this.first = true;
    }

    protected String getEncoding(TransformContext cxt) {
        String encoding = (String)cxt.getProperty("encoding");
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        return encoding;
    }

    private void writeHeader(ExternalObject obj, OutputDevice outputdevice, TransformContext cxt) throws TransformException, RemoteException {
        ExternalObject externalObject = this.toExternalObject(obj);
        Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
        BatchWriterImpl.writeToDevice(headerPart, outputdevice);
    }

    public void writeMessage(ExternalObject obj, OutputDevice outputdevice, TransformContext cxt) throws TransformException, RemoteException {
        this.writer.setExceptionHandler(this.exceptionHandler);
        this.lastObject = obj;
        if (this.first) {
            this.first = false;
            if (outputdevice instanceof RawMessage) {
                RawMessage rm = (RawMessage)((Object)outputdevice);
                rm.setEncoding(this.getEncoding(cxt));
            }
            this.writeHeader(obj, outputdevice, cxt);
        }
        ExternalObject externalObject = this.toExternalObject(obj);
        Object dataPart = this.writer.writeData(externalObject.getData(), cxt);
        BatchWriterImpl.writeToDevice(dataPart, outputdevice);
    }

    public void endBatch(OutputDevice outputdevice, TransformContext cxt) throws TransformException, RemoteException {
        this.writeTrailer(this.toExternalObject(this.lastObject), outputdevice, cxt);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    private void writeTrailer(ExternalObject obj, OutputDevice outputdevice, TransformContext cxt) throws TransformException, RemoteException {
        ExternalObject externalObject = this.toExternalObject(obj);
        Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
        BatchWriterImpl.writeToDevice(trailerPart, outputdevice);
    }

    public Object serializeHeader(DataObject header, TransformContext cxt) throws TransformException {
        Object[] messageParts = new Object[3];
        this.writer.setExceptionHandler(this.exceptionHandler);
        messageParts[0] = this.writer.writeStartMessage();
        messageParts[1] = this.writer.writeHeader(header, cxt);
        messageParts[2] = this.writer.writeBodyStart();
        return messageParts;
    }

    public Object serializeTrailer(DataObject trailer, TransformContext cxt) throws TransformException {
        Object[] messageParts = new Object[3];
        this.writer.setExceptionHandler(this.exceptionHandler);
        messageParts[0] = this.writer.writeBodyEnd();
        messageParts[1] = this.writer.writeTrailer(trailer, cxt);
        messageParts[2] = this.writer.writeEndMessage();
        return messageParts;
    }

    protected Object serializeData(DataObject record, TransformContext cxt) throws TransformException {
        this.writer.setExceptionHandler(this.exceptionHandler);
        return this.writer.writeData(record, cxt);
    }

    ExternalObject toExternalObject(DataObject obj) {
        if (obj instanceof ExternalObject) {
            return (ExternalObject)obj;
        }
        if (obj == null) {
            throw TransformRuntimeException.createFormatted("SRT660");
        }
        throw TransformRuntimeException.createFormatted("SRT661", obj.getClass().getName());
    }

    public static void writeToDevice(Object obj, OutputDevice device) throws TransformException, RemoteException {
        if (obj instanceof Object[]) {
            Object[] messageParts = (Object[])obj;
            for (int i = 0; i < messageParts.length; ++i) {
                if (messageParts[i] == null) continue;
                device.write(messageParts[i]);
            }
        } else {
            device.write(obj);
        }
    }
}

