/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.runtime.TransformException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class Binary
implements Serializable {
    public static final int FF_MASK = 255;
    final byte[] bytes;
    final int startIndex;
    final int length;
    private static final long serialVersionUID = 1L;

    public Binary(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public Binary(byte[] bytes, int startIndex, int length) {
        this.bytes = bytes;
        this.startIndex = startIndex;
        this.length = length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLength() {
        return this.length;
    }

    public int getByte(long at) {
        if (at < (long)this.bytes.length) {
            return this.bytes[(int)at + this.startIndex] & 0xFF;
        }
        return -1;
    }

    public int getByte(int at) {
        return this.bytes[at + this.startIndex] & 0xFF;
    }

    public int getBytes(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        num_chars = (int)Math.min((long)this.length - start_index, (long)num_chars);
        System.arraycopy(this.bytes, (int)start_index + this.startIndex, toRet, destLocation, num_chars);
        return num_chars;
    }

    public Binary sub(int beginIndex) {
        return this.sub(beginIndex, this.length);
    }

    public Binary sub(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return beginIndex == 0 && endIndex == this.length ? this : new Binary(this.bytes, this.startIndex + beginIndex, endIndex - beginIndex);
    }

    public byte[] getAsBytes() {
        if (this.startIndex == 0 && this.length == this.bytes.length) {
            return this.bytes;
        }
        byte[] toRet = new byte[this.length];
        System.arraycopy(this.bytes, this.startIndex, toRet, 0, this.length);
        return toRet;
    }

    public String bytesToString(String encoding) throws TransformException {
        try {
            return CharBinaryBuffer.bytesToString(this.bytes, this.startIndex, this.length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            TransformException te = TransformException.createFormatted("SRT669");
            te.setDetail(e);
            throw te;
        }
    }

    public InputStream getAsStream() {
        return new ByteArrayInputStream(this.getBytes(), this.getStartIndex(), this.getLength());
    }

    public static int getByteAt(byte[] bytes, int index) {
        return bytes[index] & 0xFF;
    }
}

