/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.FileInputOutputMessage;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.RawInputMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.RawOutputMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.VolanteIOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CachedMessage
extends AbstractRawMessage
implements RawOutputMessage,
RawInputMessage {
    private static final int DEFAULT_MAX_MEMORY_LENGTH = 262144;
    FileInputOutputMessage fileInputOutputMessage;
    MemoryRawOutputMessage memoryRawOutputMessage;
    RawMessage delegate;
    private String outputDir;
    private int threshold;

    public CachedMessage(String encoding) {
        this(encoding, null, 262144);
    }

    public CachedMessage(String encoding, String outputDir, int threshold) {
        this.outputDir = outputDir;
        this.threshold = threshold;
        this.memoryRawOutputMessage = new MemoryRawOutputMessage(encoding);
        this.delegate = this.memoryRawOutputMessage;
    }

    private synchronized void verifySize(int length) throws TransformException {
        if (this.delegate == this.memoryRawOutputMessage && this.memoryRawOutputMessage.getLength() + length > this.threshold) {
            try {
                File tempFile = this.createTempFile();
                this.fileInputOutputMessage = new FileInputOutputMessage(tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new TransformException("Error creating temporary file for caching", e);
            }
            this.fileInputOutputMessage.append(this.memoryRawOutputMessage);
            this.delegate = this.fileInputOutputMessage;
            this.memoryRawOutputMessage = null;
        }
    }

    private File createTempFile() throws IOException {
        File tempFile = this.outputDir == null ? VolanteIOUtil.createTempFile("vos", ".tmp") : VolanteIOUtil.createTempFile("vos", ".tmp", new File(this.outputDir));
        return tempFile;
    }

    public synchronized void append(byte[] bytes) throws TransformException {
        this.verifySize(bytes.length);
        this.delegate.append(bytes);
    }

    public synchronized void append(byte[] bytes, int off, int len) throws TransformException {
        this.verifySize(bytes.length);
        this.delegate.append(bytes, off, len);
    }

    public synchronized void append(String str) throws TransformException {
        this.verifySize(str.length());
        this.delegate.append(str);
    }

    public synchronized void append(RawMessage message) throws TransformException {
        this.verifySize(message.getLength());
        this.delegate.append(message);
    }

    public synchronized int getLength() throws TransformException {
        return this.delegate.getLength();
    }

    public synchronized long getLongLength() throws TransformException {
        return this.delegate.getLongLength();
    }

    public synchronized int getBytes(long start_index, byte[] toRetBytes, int destLocation, int num_bytes) throws TransformException {
        return this.delegate.getBytes(start_index, toRetBytes, destLocation, num_bytes);
    }

    public synchronized int getByte(long at) throws TransformException {
        return this.delegate.getByte(at);
    }

    public synchronized String getAsString(String encoding) throws TransformException {
        return this.delegate.getAsString(encoding);
    }

    public synchronized String getAsString() throws TransformException {
        return this.delegate.getAsString();
    }

    public synchronized InputStream getAsStream() throws TransformException {
        return this.delegate.getAsStream();
    }

    public byte[] getAsBytes() throws TransformException {
        return this.delegate.getAsBytes();
    }

    public Object getAsObject() throws TransformException {
        return this.delegate.getAsObject();
    }

    public void dispose() throws TransformException {
        FileInputOutputMessage inputOutputMessage;
        String path;
        this.delegate.dispose();
        if (this.delegate instanceof FileInputOutputMessage && (path = (inputOutputMessage = (FileInputOutputMessage)this.delegate).getStringProperty("file.path", null)) == null) {
            new File(path).delete();
        }
    }
}

