/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.InputFormat;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MessageIdentifier;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import java.util.Properties;
import javax.naming.NamingException;

public class CartridgeMessageIdentifier
implements MessageIdentifier {
    String inputFormatName;
    LookupContext lcxt;
    InputFormat inputFormat;

    public void init(Properties props) {
        this.inputFormatName = props.getProperty("input.format");
    }

    public synchronized DataObject identifyMessage(InputSource is) {
        try {
            TransformContextImpl tcxt = new TransformContextImpl();
            tcxt.setProperty("input.source", "MessageID");
            NormalizedObject[] nobjs = this.getInputFormat().handleInput(is, (TransformContext)tcxt);
            return nobjs[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputFormat getInputFormat() throws NamingException {
        if (this.inputFormat == null) {
            if (this.lcxt == null) {
                this.lcxt = LookupContextFactory.getLookupContext();
            }
            this.inputFormat = this.lcxt.lookupInputFormat(this.inputFormatName);
        }
        return this.inputFormat;
    }
}

