/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.TransformException;

public class CustomClassSupport {
    ClassLoader classLoader;

    public CustomClassSupport(ClassLoader loader) {
        this.classLoader = loader;
    }

    public CustomClassSupport(Class cls) {
        this.classLoader = cls.getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static Class loadClass(String className, ClassLoader loader, Class type) throws TransformException {
        try {
            Class<?> cls = Class.forName(className, true, loader);
            if (type.isAssignableFrom(cls)) {
                return cls;
            }
            throw TransformException.createFormatted("SRT185", new Object[]{className, type.getName()});
        }
        catch (Exception e) {
            CustomClassSupport.handleException(e, className);
            return type;
        }
    }

    public static Object createInstance(String className, ClassLoader loader, Class type) throws TransformException {
        Class cls = CustomClassSupport.loadClass(className, loader, type);
        try {
            Object obj = cls.newInstance();
            return obj;
        }
        catch (Exception e) {
            return CustomClassSupport.handleException(e, className);
        }
    }

    static Object handleException(Exception e, String className) throws TransformException {
        if (e instanceof ClassNotFoundException) {
            TransformException te = TransformException.createFormatted("SRT186", className);
            te.setDetail(e);
            throw te;
        }
        if (e instanceof InstantiationException) {
            TransformException te = TransformException.createFormatted("SRT187", className);
            te.setDetail(e);
            throw te;
        }
        if (e instanceof IllegalAccessException) {
            TransformException te = TransformException.createFormatted("SRT187", className);
            te.setDetail(e);
            throw te;
        }
        if (e instanceof TransformException) {
            throw (TransformException)e;
        }
        return null;
    }
}

