/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectConverter;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.LocationInfoImpl;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.PropertyMapDelegate;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.util.xml.QName;
import java.util.Map;

public abstract class DataObjectBase
extends PropertyMapDelegate
implements DataObject {
    static final long serialVersionUID = 5053794282503561005L;

    public DataObjectSection getSection(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.getSection(index);
    }

    public DataObjectSection getSection(int index) throws FieldNotFoundException {
        Object field = this.getField(index);
        if (field == null ? !this.getMetaInfo().getFieldMetaInfo(index).isSection() : !(field instanceof DataObjectSection)) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT168", String.valueOf(index));
        }
        return (DataObjectSection)field;
    }

    public int getSectionElementCount(int index) throws FieldNotFoundException {
        return ((DataObjectSection)this.getField(index)).getElementCount();
    }

    public Object getField(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.getField(index);
    }

    public void setField(String fieldName, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        int index = this.getFieldIndex(fieldName);
        this.setField(index, value);
    }

    public boolean isNotNull(int index) throws FieldNotFoundException {
        return !this.isNull(index);
    }

    public boolean isNull(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.isNull(index);
    }

    public void setNull(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        this.setNull(index);
    }

    public boolean isSynthesized(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.isSynthesized(index);
    }

    public void reset() {
        this.setAllFieldsToNull();
    }

    protected void setAllFieldsToNull() {
        int fldCount = this.getMetaInfo().getFieldCount();
        for (int i = 0; i < fldCount; ++i) {
            try {
                this.setNull(i);
                continue;
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
    }

    public String getRootXMLTag() {
        String name = this.getMetaInfo().getName();
        if (name == null) {
            name = "DataObject";
        }
        return name;
    }

    public QName getXMLQName() {
        DataObjectMetaInfo dataObjectMetaInfo = this.getMetaInfo();
        return dataObjectMetaInfo.getXMLQName();
    }

    public XMLFieldType getFieldXMLType() {
        DataObjectMetaInfo dataObjectMetaInfo = this.getMetaInfo();
        return dataObjectMetaInfo.getFieldXMLType();
    }

    public void fromMap(Map map) throws TransformException {
        DataObjectConverter.fromMap(this, map);
    }

    public static final Object runtimeObjectToString(Object obj, String type) {
        return Parsing.runtimeObjectToString(obj, type);
    }

    public static final Object toRuntimeObject(Object obj, String type) throws TransformException {
        return Parsing.toRuntimeObject(obj, type);
    }

    public String toXMLString() {
        return this.toXMLString(1);
    }

    public String toXMLString(int indent) {
        return DataObjectXML.toXMLString(this, indent);
    }

    public String getMangledName(String fieldName) throws FieldNotFoundException {
        return this.getMetaInfo().getMangledName(fieldName);
    }

    public final String toString() {
        return this.toXMLString();
    }

    public abstract Object getField(int var1) throws FieldNotFoundException;

    public abstract void setField(int var1, Object var2) throws FieldNotFoundException, FieldTypeMismatchException;

    public int getFieldCount() {
        return this.getMetaInfo().getFieldCount();
    }

    public String getMessageName() {
        return this.getMetaInfo().getName();
    }

    public int getFieldIndex(String fieldName) throws FieldNotFoundException {
        return this.getMetaInfo().getFieldIndex(fieldName);
    }

    public String getFieldName(int index) throws FieldNotFoundException {
        return this.getMetaInfo().getFieldName(index);
    }

    public String getFieldType(int index) throws FieldNotFoundException {
        return this.getMetaInfo().getFieldType(index);
    }

    public String getFieldType(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.getFieldType(index);
    }

    public DesignerType getFieldDesignerType(int index) throws FieldNotFoundException {
        return this.getMetaInfo().getFieldDesignerType(index);
    }

    public DesignerType getFieldDesignerType(String fieldName) throws FieldNotFoundException {
        int index = this.getFieldIndex(fieldName);
        return this.getFieldDesignerType(index);
    }

    public boolean isSynthesized(int index) throws FieldNotFoundException {
        return this.getMetaInfo().isSynthesized(index);
    }

    public FieldMetaInfo getFieldMetaInfo(int index) throws FieldNotFoundException {
        return this.getMetaInfo().getFieldMetaInfo(index);
    }

    public String getQualifiedName(String fieldName) throws FieldNotFoundException {
        return this.getQualifiedName(this.getMetaInfo().getFieldIndex(fieldName));
    }

    public boolean exists(int index) throws FieldNotFoundException {
        FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfo(index);
        if (fieldMetaInfo.isSection()) {
            Object obj = this.getField(index);
            if (obj instanceof DataObjectSection) {
                DataObjectSection sec = (DataObjectSection)obj;
                return sec.getElementCount() > 0;
            }
            return obj != null;
        }
        return !this.isNull(index);
    }

    public boolean exists(int[] index) throws FieldNotFoundException {
        return this.exists(index, 0);
    }

    public boolean exists(int[] index, int current) throws FieldNotFoundException {
        int currentIndex = index[current];
        FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfo(currentIndex);
        if (fieldMetaInfo.isSection()) {
            Object obj = this.getField(currentIndex);
            if (obj instanceof DataObjectSection) {
                DataObjectSection sec = (DataObjectSection)obj;
                if (current == index.length - 1) {
                    return sec.getElementCount() > 0;
                }
                for (int i = 0; i < sec.getElementCount(); ++i) {
                    DataObjectBase element = (DataObjectBase)sec.getElement(i);
                    if (!element.exists(index, current + 1)) continue;
                    return true;
                }
                return false;
            }
            return obj != null;
        }
        return !this.isNull(currentIndex);
    }

    public abstract boolean isNull(int var1) throws FieldNotFoundException;

    public Object getFieldCheckNull(int index) throws FieldNullException, FieldNotFoundException {
        Object toRet = this.getField(index);
        if (toRet == null) {
            FieldNullException fne = FieldNullException.createFieldNullExceptionFormatted("SRT600", this.getQualifiedName(index));
            fne.setField(this, index, null);
            throw fne;
        }
        return toRet;
    }

    public Object getFieldCheckNull(String fieldName) throws FieldNullException, FieldNotFoundException {
        return this.getFieldCheckNull(this.getMetaInfo().getFieldIndex(fieldName));
    }

    public DataObject createSectionElement(String sectionName, DataObjectSection sec) throws FieldNotFoundException {
        return this.createSectionElement(this.getMetaInfo().getFieldIndex(sectionName), sec);
    }

    public int getElementIndex() {
        DataObjectSection parentSection = this.getParentSection();
        if (parentSection != null) {
            return parentSection.getElementIndex(this);
        }
        return -1;
    }

    public DataObject createSectionElement(int index, DataObjectSection sec) throws FieldNotFoundException {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT178A", Parsing.toString(index));
    }

    public String getFieldID(int index) throws FieldNotFoundException {
        String id = this.getID();
        if (id.length() > 0) {
            return id + "." + this.getFieldName(index);
        }
        return this.getFieldName(index);
    }

    public LocationInfo getLocationInfo() {
        return null;
    }

    public String getID() {
        String parentIdWithIndex = "";
        DataObjectSection parentSection = this.getParentSection();
        if (parentSection != null) {
            int index = parentSection.getElementIndex(this);
            parentIdWithIndex = DataObjectBase.getID(parentSection, index);
        }
        return parentIdWithIndex;
    }

    public static String getID(DataObjectSection parentSection, int index) {
        String parentIdWithIndex = parentSection.getID();
        if (index > 0 || parentSection.getMaxOccurs() == -1 || parentSection.getMaxOccurs() > 1) {
            parentIdWithIndex = parentIdWithIndex + "[" + index + "]";
        }
        return parentIdWithIndex;
    }

    public String getQualifiedName() {
        String qualifiedName = "";
        DataObjectSection parentSection = this.getParentSection();
        if (parentSection != null) {
            qualifiedName = parentSection.getQualifiedName();
        }
        return qualifiedName;
    }

    public static DataObject getParentDataObject(DataObject root, String fieldId) throws FieldNotFoundException {
        int dotIndex;
        DataObject dataObj = root;
        while ((dotIndex = fieldId.indexOf(46)) != -1) {
            int secIndex = 0;
            String secName = fieldId.substring(0, dotIndex);
            int bracStartIndex = secName.indexOf(91);
            if (bracStartIndex != -1) {
                int bracEndIndex = secName.indexOf("]", bracStartIndex);
                String indexValueStr = secName.substring(bracStartIndex + 1, bracEndIndex);
                try {
                    secIndex = Integer.parseInt(indexValueStr);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                secName = secName.substring(0, bracStartIndex);
            }
            fieldId = fieldId.substring(dotIndex + 1);
            DataObjectSection section = dataObj.getSection(secName);
            dataObj = section.getElement(secIndex);
        }
        dataObj.getField(fieldId);
        return dataObj;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof DataObjectBase)) {
            return false;
        }
        DataObjectBase other = (DataObjectBase)otherObj;
        int count = this.getFieldCount();
        if (other.getFieldCount() != count) {
            return false;
        }
        DataObjectMetaInfo metaInfo1 = this.getMetaInfo();
        DataObjectMetaInfo metaInfo2 = other.getMetaInfo();
        for (int i = 0; i < count; ++i) {
            Object fldVal2;
            Object fldVal1 = this.getField(i);
            if (fldVal1 == (fldVal2 = other.getField(i))) continue;
            if (fldVal1 == null || fldVal2 == null) {
                return false;
            }
            if (!fldVal1.equals(fldVal2)) {
                return false;
            }
            if (metaInfo1.getFieldMetaInfo(i).equals(metaInfo2.getFieldMetaInfo(i))) continue;
            return false;
        }
        return true;
    }

    protected LocationInfo getOrCreateLocationInfo(LocationInfo locationInfo) {
        if (locationInfo == null) {
            return new LocationInfoImpl(this);
        }
        return locationInfo;
    }

    public Object clone() {
        DataObjectBase cloned = (DataObjectBase)super.clone();
        return cloned;
    }

    public static Object cloneFields(DataObjectBase from, DataObjectBase cloned, boolean includeFields) {
        try {
            int count = from.getFieldCount();
            DataObjectMetaInfo metaInfo = from.getMetaInfo();
            for (int i = 0; i < count; ++i) {
                Object obj;
                if (metaInfo.isSection(i)) {
                    obj = from.getField(i);
                    if (!(obj instanceof DataObjectSection)) continue;
                    DataObjectSection sec = (DataObjectSection)obj;
                    DataObjectSection copySection = (DataObjectSection)sec.clone();
                    copySection.setParent(cloned);
                    cloned.setField(i, (Object)copySection);
                    continue;
                }
                if (!includeFields) continue;
                obj = from.getField(i);
                cloned.setField(i, obj);
            }
            return cloned;
        }
        catch (FieldTypeMismatchException e) {
            throw new InternalError();
        }
    }

    public static void dispose(DataObject obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < obj.getFieldCount(); ++i) {
            Object fldVal = obj.getField(i);
            if (fldVal instanceof DataObject) {
                DataObjectBase.dispose((DataObject)fldVal);
            } else if (fldVal instanceof DataObjectSection) {
                DataObjectBase.dispose((DataObjectSection)fldVal);
            }
            obj.setNull(i);
        }
    }

    public static void dispose(DataObjectSection section) {
        int size = section.size();
        for (int j = 0; j < size; ++j) {
            DataObject element = section.getElement(j);
            DataObjectBase.dispose(element);
        }
        section.clear();
    }

    public static void copy(DataObject obj1, DataObject obj2) {
        for (int i = 0; i < obj1.getFieldCount(); ++i) {
            Object fldVal = obj1.getField(i);
            if (fldVal instanceof DataObject) {
                DataObject fldVal2 = (DataObject)obj2.getField(i);
                DataObjectBase.copy((DataObject)fldVal, fldVal2);
                continue;
            }
            if (fldVal instanceof DataObjectSection) {
                DataObjectSection sec2 = obj2.getSection(i);
                sec2.clear();
                DataObjectSection sec1 = (DataObjectSection)fldVal;
                DataObjectBase.copy(sec1, sec2);
                continue;
            }
            obj2.setField(i, fldVal);
        }
    }

    public static void copy(DataObjectSection sec1, DataObjectSection sec2) {
        for (int j = 0; j < sec1.getElementCount(); ++j) {
            DataObject dObj = sec1.getElement(j);
            DataObject dObj2 = sec2.createElement();
            DataObjectBase.copy(dObj, dObj2);
            sec2.addElement(dObj2);
        }
    }

    public static void copyLenient(DataObject obj1, DataObject obj2) {
        DataObjectMetaInfo metaInfo1 = obj1.getMetaInfo();
        DataObjectMetaInfo metaInfo2 = obj2.getMetaInfo();
        for (int i = 0; i < obj1.getFieldCount(); ++i) {
            FieldMetaInfo fieldMetaInfo1 = metaInfo1.getFieldMetaInfo(i);
            String fieldName1 = fieldMetaInfo1.getName();
            DesignerType fieldType1 = fieldMetaInfo1.getDesignerType();
            FieldMetaInfo fieldMetaInfo2 = metaInfo2.getFieldMetaInfoOrNull(fieldName1);
            if (fieldMetaInfo2 == null || fieldMetaInfo2.getDesignerType() != fieldType1 || obj1.isNull(i)) continue;
            int index2 = fieldMetaInfo2.getIndex();
            Object fldVal = obj1.getField(i);
            if (fldVal instanceof DataObject) {
                DataObject fldVal2 = (DataObject)obj2.getField(index2);
                DataObjectBase.copyLenient((DataObject)fldVal, fldVal2);
                continue;
            }
            if (fldVal instanceof DataObjectSection) {
                DataObjectSection sec2 = obj2.getSection(index2);
                sec2.clear();
                DataObjectSection sec1 = (DataObjectSection)fldVal;
                DataObjectBase.copyLenient(sec1, sec2);
                continue;
            }
            obj2.setField(index2, fldVal);
        }
    }

    public static void copyLenient(DataObjectSection sec1, DataObjectSection sec2) {
        for (int j = 0; j < sec1.getElementCount(); ++j) {
            DataObject dObj = sec1.getElement(j);
            DataObject dObj2 = sec2.createElement();
            DataObjectBase.copyLenient(dObj, dObj2);
            sec2.addElement(dObj2);
        }
    }

    public static Object toRawMessage(Object o) {
        if (o == null || o instanceof RawMessage) {
            return o;
        }
        if (o instanceof byte[]) {
            return new ByteArrayInputSource((byte[])o);
        }
        if (o instanceof String) {
            return new StringInputSource((String)o);
        }
        return o;
    }

    public static void removeEmptyFields(DataObject obj) {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            String fieldValue;
            FieldMetaInfo fieldInfo = metaInfo.getFieldMetaInfo(i);
            if (fieldInfo.isSection()) {
                Object secObj = obj.getField(i);
                if (secObj instanceof DataObjectSection) {
                    DataObjectSection sec = (DataObjectSection)secObj;
                    for (int j = 0; j < sec.size(); ++j) {
                        DataObject secElm = (DataObject)sec.get(j);
                        DataObjectBase.removeEmptyFields(secElm);
                        if (!secElm.isEmpty()) continue;
                        sec.remove(j);
                        --j;
                    }
                }
                if (!(secObj instanceof DataObject)) continue;
                DataObject subObj = (DataObject)secObj;
                DataObjectBase.removeEmptyFields(subObj);
                continue;
            }
            if (fieldInfo.getDesignerType() != DesignerTypes.STRING_TYPE || (fieldValue = (String)obj.getField(i)) == null || fieldValue.length() != 0) continue;
            obj.setNull(i);
        }
    }
}

