/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataObjectConverter {
    public static void fromMap(DataObject dataObj, Map map) throws TransformException {
        if (map == null) {
            map = new HashMap();
        }
        DataObjectMetaInfo metaInfo = dataObj.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
            String name = fieldMetaInfo.getName();
            String mangledName = fieldMetaInfo.getMangledName();
            DesignerType type = fieldMetaInfo.getDesignerType();
            Object obj = map.get(name);
            if (obj == null) {
                obj = map.get(mangledName);
            }
            if (type.equals(DesignerTypes.SECTION_TYPE)) {
                DataObjectSection sec = dataObj.getSection(i);
                sec.clear();
                if (obj instanceof List) {
                    List sectionList = (List)obj;
                    DataObjectConverter.fromList(sec, sectionList);
                    continue;
                }
                if (obj instanceof String && ((String)obj).trim().length() == 0) {
                    sec.addElement(sec.createElement());
                    continue;
                }
                if (obj == null) continue;
                throw TransformException.createFormatted("SRT175", new Object[]{name, obj});
            }
            if (obj != null) {
                try {
                    Object runtimeObj = Parsing.toRuntimeObject(obj, type, true);
                    dataObj.setField(i, runtimeObj);
                    continue;
                }
                catch (TransformException e) {
                    e.setFieldName(dataObj.getQualifiedName(i));
                    throw e;
                }
                catch (Exception e) {
                    TransformException te = TransformException.createFormatted("SRT176");
                    te.setFieldName(dataObj.getQualifiedName(i));
                    te.setDetail(e);
                    throw te;
                }
            }
            dataObj.setNull(i);
        }
    }

    public static void fromList(DataObjectSection section, List list) throws TransformException {
        section.clear();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            if (map == null) continue;
            DataObject obj = section.createElement();
            obj.fromMap(map);
            section.addElement(obj);
        }
    }
}

