/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfo;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DataObjectMapAdapter
extends AbstractMap
implements Map {
    DataObject obj;

    public DataObjectMapAdapter(DataObject obj) {
        this.obj = obj;
    }

    public int size() {
        int size = 0;
        int count = this.obj.getFieldCount();
        for (int i = 0; i < count; ++i) {
            if (this.obj.isNull(i)) continue;
            ++size;
        }
        return size;
    }

    public Object get(Object key) {
        String fieldName = (String)key;
        return this.obj.getField(fieldName);
    }

    public Object put(Object key, Object value) {
        String fieldName = (String)key;
        Object old = this.obj.getField(fieldName);
        this.obj.setField(fieldName, value);
        return old;
    }

    public Object remove(Object key) {
        String fieldName = (String)key;
        Object old = this.obj.getField(fieldName);
        this.obj.setNull(fieldName);
        return old;
    }

    public boolean containsKey(Object key) {
        String fieldName = (String)key;
        int index = this.obj.getMetaInfo().getFieldIndexIfExists(fieldName);
        return index != -1 && this.obj.getField(index) != null;
    }

    public boolean isEmpty() {
        int count = this.obj.getFieldCount();
        for (int i = 0; i < count; ++i) {
            if (this.obj.isNull(i)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        int count = this.obj.getFieldCount();
        for (int i = 0; i < count; ++i) {
            this.obj.setNull(i);
        }
    }

    public Set keySet() {
        return super.keySet();
    }

    public Set entrySet() {
        DataObjectMetaInfo dataObjectMetaInfo = this.obj.getMetaInfo();
        int count = this.obj.getFieldCount();
        HashSet entries = new HashSet(){

            public boolean remove(Object o) {
                Entry entry = (Entry)o;
                if (!DataObjectMapAdapter.this.obj.isNull(entry.fieldMetaInfo.getIndex())) {
                    DataObjectMapAdapter.this.obj.setNull(entry.fieldMetaInfo.getIndex());
                    return true;
                }
                return false;
            }
        };
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo fieldMetaInfo = dataObjectMetaInfo.getFieldMetaInfo(i);
            if (this.obj.getField(i) == null) continue;
            entries.add(new Entry(fieldMetaInfo));
        }
        return entries;
    }

    class Entry
    implements Map.Entry {
        FieldMetaInfo fieldMetaInfo;

        Entry(FieldMetaInfo fieldMetaInfo) {
            this.fieldMetaInfo = fieldMetaInfo;
        }

        public Object getKey() {
            return this.fieldMetaInfo.getName();
        }

        public Object getValue() {
            return DataObjectMapAdapter.this.obj.getField(this.fieldMetaInfo.getIndex());
        }

        public Object setValue(Object value) {
            Object old = DataObjectMapAdapter.this.obj.getField(this.fieldMetaInfo.getIndex());
            DataObjectMapAdapter.this.obj.setField(this.fieldMetaInfo.getIndex(), value);
            return old;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.fieldMetaInfo.equals(entry.fieldMetaInfo);
        }

        public int hashCode() {
            return this.fieldMetaInfo.hashCode();
        }
    }
}

