/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.util.xml.QName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataObjectMetaInfoImpl
implements DataObjectMetaInfo,
Cloneable,
Serializable {
    String name;
    protected List fields = new ArrayList();
    private Map fldMap;
    SectionMetaInfo parentSection;
    Map xmlQNameMap;
    private XMLFieldType fieldXMLType;
    QName qName;
    private boolean elements;
    private boolean attributes;
    private FieldMetaInfo valueFieldMetaInfo;
    static final long serialVersionUID = 11L;

    public DataObjectMetaInfoImpl(String name) {
        this.name = name;
    }

    public DataObjectMetaInfoImpl(String name, String xmlName, String xmlNameSpace) {
        this.name = name;
    }

    public DataObjectMetaInfoImpl(String name, DataObjectMetaInfo baseMetaInfo, FieldMetaInfo[] fields) {
        this.init(name, baseMetaInfo, fields);
    }

    public DataObjectMetaInfoImpl(String name, FieldMetaInfo[] fields) {
        this.init(name, null, fields);
    }

    private void init(String name, DataObjectMetaInfo baseMetaInfo, FieldMetaInfo[] fields) {
        this.name = name;
        this.initFields(baseMetaInfo, fields);
    }

    public DataObjectMetaInfoImpl(String[] fieldNames, String[] types) {
        this.name = "DataObject";
        this.addFields(fieldNames, types, null);
        this.getFieldMap();
    }

    public DataObjectMetaInfoImpl(String[] fieldNames, DesignerType[] types) {
        this.name = "DataObject";
        this.addFields(fieldNames, types, null);
        this.getFieldMap();
    }

    public void initFields(FieldMetaInfo[] fields) {
        this.initFields(null, fields);
    }

    public void initFields(DataObjectMetaInfo baseMetaInfo, FieldMetaInfo[] fields) {
        if (baseMetaInfo != null) {
            this.addParentFields(baseMetaInfo.getFields());
        }
        this.addFields(fields);
        this.getFieldMap();
        this.setParent();
        this.analyze();
        this.prepareXMLQNameCache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyze() {
        try {
            int fieldCount = this.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                FieldMetaInfo info = this.getFieldMetaInfo(i);
                XMLFieldType xmlFieldType = info.getFieldXMLType();
                if (xmlFieldType == XMLFieldType.ELEMENT) {
                    this.elements = true;
                    continue;
                }
                if (xmlFieldType == XMLFieldType.GROUP) {
                    this.elements = true;
                    continue;
                }
                if (xmlFieldType == XMLFieldType.ANY) {
                    this.elements = true;
                    continue;
                }
                if (xmlFieldType == XMLFieldType.ATTRIBUTE) {
                    this.attributes = true;
                    continue;
                }
                if (xmlFieldType == XMLFieldType.ANYATTRIBUTE) {
                    this.attributes = true;
                    continue;
                }
                if (xmlFieldType != XMLFieldType.VALUE) continue;
                this.valueFieldMetaInfo = info;
            }
            if (!this.hasXMLAttributes()) return;
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    public void setParentSection(SectionMetaInfo parentSection) {
        this.parentSection = parentSection;
    }

    public SectionMetaInfo getParentSection() {
        return this.parentSection;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean isSynthesized(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).isSynthesized();
    }

    public boolean isSection(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).isSection();
    }

    public FieldMetaInfo getFieldMetaInfo(int index) throws FieldNotFoundException {
        if (index < 0 || index >= this.fields.size()) {
            this.throwOutOfRange(index);
        }
        return (FieldMetaInfo)this.fields.get(index);
    }

    public SectionMetaInfo getSectionMetaInfo(int index) throws FieldNotFoundException {
        return (SectionMetaInfo)this.getFieldMetaInfo(index);
    }

    public String getQualifiedName() {
        DataObjectMetaInfoImpl parentMetaInfo = this;
        SectionMetaInfo sectionMetaInfo = parentMetaInfo.getParentSection();
        if (sectionMetaInfo != null) {
            return sectionMetaInfo.getQualifiedName();
        }
        return this.getName();
    }

    private void throwOutOfRange(int index) {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT164", new String[]{String.valueOf(index), this.getQualifiedName()});
    }

    protected FieldMetaInfo getFieldMetaInfo0(int index) {
        return (FieldMetaInfo)this.fields.get(index);
    }

    public String getFieldName(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).getName();
    }

    public String getQualifiedName(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).getQualifiedName();
    }

    public String getFieldType(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).getType();
    }

    public DesignerType getFieldDesignerType(int index) throws FieldNotFoundException {
        return this.getFieldMetaInfo(index).getDesignerType();
    }

    public String getMangledName(int index) throws FieldNotFoundException {
        FieldMetaInfo info = this.getFieldMetaInfo(index);
        return info.getMangledName();
    }

    public String getMangledName(String fieldName) throws FieldNotFoundException {
        FieldMetaInfo info = this.getFieldMetaInfo(fieldName);
        return info.getMangledName();
    }

    public int getFieldIndex(String fieldName) throws FieldNotFoundException {
        return this.getFieldMetaInfo(fieldName).getIndex();
    }

    public int getFieldIndexIfExists(String fieldName) {
        FieldMetaInfo fieldInfo = (FieldMetaInfo)this.getFieldMap().get(fieldName);
        return fieldInfo == null ? -1 : fieldInfo.getIndex();
    }

    public FieldMetaInfo getFieldMetaInfoOrNull(String fieldName) {
        int intIndex = -1;
        Map fieldMap = this.getFieldMap();
        FieldMetaInfo fieldInfo = (FieldMetaInfo)fieldMap.get(fieldName);
        return fieldInfo;
    }

    public FieldMetaInfo getFieldMetaInfo(String fieldName) throws FieldNotFoundException {
        FieldMetaInfo fieldInfo = (FieldMetaInfo)this.getFieldMap().get(fieldName);
        if (fieldInfo == null) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT165", new String[]{fieldName, this.getQualifiedName()});
        }
        return fieldInfo;
    }

    public FieldMetaInfo getFieldMetaInfo(QName fieldName) throws FieldNotFoundException {
        FieldMetaInfo fieldInfo = (FieldMetaInfo)this.getXMLQNameMap().get(fieldName);
        if (fieldInfo == null) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT165", new String[]{fieldName.toString(), this.getQualifiedName()});
        }
        return fieldInfo;
    }

    public FieldMetaInfo getFieldMetaInfoOrNull(QName fieldName) {
        FieldMetaInfo fieldInfo = (FieldMetaInfo)this.getXMLQNameMap().get(fieldName);
        return fieldInfo;
    }

    protected Map getFieldMap() {
        if (this.fldMap == null) {
            this.fldMap = this.createMap();
            for (int i = 0; i < this.fields.size(); ++i) {
                FieldMetaInfo fieldInfo = (FieldMetaInfo)this.fields.get(i);
                this.fldMap.put(fieldInfo.getName(), fieldInfo);
                this.fldMap.put(fieldInfo.getMangledName(), fieldInfo);
            }
        }
        return this.fldMap;
    }

    private void addParentFields(List fields) {
        this.fields.addAll(fields);
    }

    private void addFields(FieldMetaInfo[] fieldArray) {
        int startIndex = this.fields.size();
        for (int i = 0; i < fieldArray.length; ++i) {
            FieldMetaInfo fieldInfo = fieldArray[i];
            fieldInfo.setIndex(startIndex + i);
            this.fields.add(fieldInfo);
        }
    }

    void setParent() {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldMetaInfo fieldMetaInfo = (FieldMetaInfo)this.fields.get(i);
            fieldMetaInfo.setParentMetaInfo(this);
        }
    }

    private void addFields(String[] fieldNames, DesignerType[] types, int[] synthesized) {
        int startIndex = this.fields.size();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            DesignerType type = types[i];
            boolean isSynthesized = DataObjectMetaInfoImpl.isSynthesized(synthesized, i);
            FieldMetaInfoImpl fieldInfo = type.equals(DesignerTypes.DESIGNER_SECTION_TYPE) ? new SectionMetaInfoImpl(null, fieldName, 0, -1, isSynthesized) : new FieldMetaInfoImpl(fieldName, type, true, isSynthesized);
            fieldInfo.setIndex(startIndex + i);
            this.fields.add(fieldInfo);
        }
    }

    private void addFields(String[] fieldNames, String[] types, int[] synthesized) {
        int startIndex = this.fields.size();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            String type = types.length > i ? types[i] : DesignerTypes.DESIGNER_STRING_TYPE;
            boolean isSynthesized = DataObjectMetaInfoImpl.isSynthesized(synthesized, i);
            FieldMetaInfoImpl fieldInfo = type.equals(DesignerTypes.DESIGNER_SECTION_TYPE) ? new SectionMetaInfoImpl(null, fieldName, 0, -1, isSynthesized) : new FieldMetaInfoImpl(fieldName, type, true, isSynthesized);
            fieldInfo.setIndex(startIndex + i);
            this.fields.add(fieldInfo);
        }
    }

    private static boolean isSynthesized(int[] synthesized, int index) {
        if (synthesized != null) {
            for (int i = 0; i < synthesized.length; ++i) {
                if (synthesized[i] != index) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getXMLName() {
        return this.getXMLQName().getLocalPart();
    }

    public QName getXMLQName() {
        if (this.qName == null) {
            SectionMetaInfo parentSection = this.getParentSection();
            if (parentSection != null) {
                this.qName = parentSection.getXMLQName();
            }
            if (this.qName == null) {
                this.qName = new QName(null, FieldMetaInfoImpl.computeMangledName(this.name));
            }
        }
        return this.qName;
    }

    public DataObjectMetaInfoImpl setXMLQName(QName qName) {
        this.qName = qName;
        return this;
    }

    public XMLFieldType getFieldXMLType() {
        if (this.fieldXMLType == null) {
            SectionMetaInfo parentSection = this.getParentSection();
            if (parentSection != null) {
                this.fieldXMLType = parentSection.getFieldXMLType();
                return this.fieldXMLType;
            }
            return XMLFieldType.ELEMENT;
        }
        return this.fieldXMLType;
    }

    public QName getRootQName() {
        return this.getXMLQName();
    }

    public XMLFieldType getXMLTypeShared(DataObject obj, FieldMetaInfo fieldMetaInfo) {
        return fieldMetaInfo.getXMLTypeShared();
    }

    public DataObjectMetaInfoImpl setFieldXMLType(XMLFieldType fieldXMLType) {
        this.fieldXMLType = fieldXMLType;
        return this;
    }

    public List getFields() {
        return this.fields;
    }

    public String toXMLString() {
        return DataObjectXML.toXMLString(this, 1);
    }

    protected Map createMap() {
        return new HashMap();
    }

    public Object clone() {
        try {
            DataObjectMetaInfoImpl copy = (DataObjectMetaInfoImpl)super.clone();
            copy.fields = new ArrayList();
            copy.fldMap = null;
            copy.parentSection = null;
            FieldMetaInfo[] clonedFields = this.fields.toArray(new FieldMetaInfo[this.fields.size()]);
            for (int i = 0; i < clonedFields.length; ++i) {
                clonedFields[i] = (FieldMetaInfo)clonedFields[i].clone();
            }
            copy.addFields(clonedFields);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectMetaInfo)) {
            return false;
        }
        DataObjectMetaInfo dataObjectMetaInfo = (DataObjectMetaInfo)o;
        if (!this.fields.equals(dataObjectMetaInfo.getFields())) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(dataObjectMetaInfo.getName()) : dataObjectMetaInfo.getName() != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + this.fields.hashCode();
        return result;
    }

    void prepareXMLQNameCache() {
        if (this.xmlQNameMap == null) {
            this.xmlQNameMap = new HashMap();
            int fieldCount = this.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                FieldMetaInfo info = this.getFieldMetaInfo0(i);
                this.xmlQNameMap.put(info.getXMLQName(), info);
            }
        }
    }

    Map getXMLQNameMap() {
        this.prepareXMLQNameCache();
        return this.xmlQNameMap;
    }

    public boolean isXMLMixedContent() {
        return this.valueFieldMetaInfo != null && this.hasXMLElements();
    }

    public boolean hasXMLAttributes() {
        return this.attributes;
    }

    public boolean hasXMLElements() {
        return this.elements;
    }

    public boolean hasXMLValueField() {
        return this.valueFieldMetaInfo != null;
    }

    public boolean isXMLValueExpected() {
        return this.valueFieldMetaInfo != null;
    }

    public FieldMetaInfo getXMLValueFieldMetaInfo() {
        return this.valueFieldMetaInfo;
    }
}

