/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractDataObjectSection;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionIndex;
import com.tplus.transform.runtime.SectionIndexImpl;
import com.tplus.transform.runtime.SectionMetaInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;

public class DataObjectSectionImpl
extends AbstractDataObjectSection {
    private transient DataObject dataObject;
    private transient DataObject[] elementData;
    private int size;
    private transient SectionIndex sectionIndex = SectionIndex.NO_OP;
    static final long serialVersionUID = 33L;

    public DataObjectSectionImpl() {
        super(null, "Section", 0, -1);
    }

    public DataObjectSectionImpl(DataObject[] objects) {
        super(null, "Section", 0, -1);
        for (int i = 0; i < objects.length; ++i) {
            DataObject object = objects[i];
            this.add(object);
        }
    }

    public DataObjectSectionImpl(DataObject parent, SectionMetaInfo metaInfo) {
        super(parent, metaInfo);
    }

    public DataObjectSectionImpl(DataObject parent, String sectionName, int minOccurs, int maxOccurs) {
        super(parent, sectionName, minOccurs, maxOccurs);
    }

    public DataObject getElement(int index) throws FieldNotFoundException {
        if (index >= 0 && index < this.size) {
            return this.getImpl(index);
        }
        return this.throwFieldNotFound(index);
    }

    public DataObjectSection findElementsWithValue(String fieldName, Object value) {
        SectionIndex secIndexForField = this.sectionIndex.getIndexFor(fieldName);
        if (secIndexForField != null) {
            return secIndexForField.findElementsWithValue(fieldName, value);
        }
        return DataObjectSectionImpl.findElementsWithValue0(this, fieldName, value);
    }

    public DataObject findElementWithValue(String fieldName, Object value) {
        SectionIndex secIndexForField = this.sectionIndex.getIndexFor(fieldName);
        if (secIndexForField != null) {
            return secIndexForField.findElementWithValue(fieldName, value);
        }
        return DataObjectSectionImpl.findElementWithValue0(this, fieldName, value);
    }

    public List getUniqueFieldValues(String fieldName) {
        SectionIndex secIndexForField = this.sectionIndex.getIndexFor(fieldName);
        if (secIndexForField != null) {
            return secIndexForField.getUniqueValues(fieldName);
        }
        return this.getUniqueFieldValues0(this, fieldName);
    }

    private List getUniqueFieldValues0(DataObjectSectionImpl src, String fieldName) {
        int fldIndex = -1;
        DesignerType type = null;
        int size = src.size();
        if (size > 0) {
            fldIndex = src.getElement(0).getFieldIndex(fieldName);
            type = src.getElement(0).getFieldDesignerType(fieldName);
        }
        HashSet<Object> toRet = new HashSet<Object>();
        for (int i = 0; i < size; ++i) {
            DataObject element = src.getElement(i);
            Object fldVal = element.getField(fldIndex);
            toRet.add(fldVal);
        }
        List list = type.createValueList();
        list.addAll(toRet);
        return list;
    }

    public static DataObjectSection findElementsWithValue0(DataObjectSection src, String fieldName, Object value) {
        SectionMetaInfo metaInfo = src.getSectionMetaInfo();
        DataObjectSectionImpl toRet = new DataObjectSectionImpl(src.getParent(), metaInfo);
        int fldIndex = -1;
        int size = src.size();
        if (size > 0) {
            fldIndex = src.getElement(0).getFieldIndex(fieldName);
        }
        for (int i = 0; i < size; ++i) {
            DataObject element = src.getElement(i);
            Object fldVal = element.getField(fldIndex);
            if (!DataObjectSectionImpl.valueEquals(fldVal, value)) continue;
            toRet.add(element);
        }
        return toRet;
    }

    public static DataObject findElementWithValue0(DataObjectSection src, String fieldName, Object value) {
        int fldIndex = -1;
        int size = src.size();
        if (size > 0) {
            fldIndex = src.getElement(0).getFieldIndex(fieldName);
        }
        for (int i = 0; i < size; ++i) {
            DataObject element = src.getElement(i);
            Object fldVal = element.getField(fldIndex);
            if (!DataObjectSectionImpl.valueEquals(fldVal, value)) continue;
            return element;
        }
        return null;
    }

    private static boolean valueEquals(Object fldVal, Object value) {
        if (fldVal == value) {
            return true;
        }
        if (fldVal == null) {
            return false;
        }
        return fldVal.equals(value);
    }

    protected DataObject throwFieldNotFound(int index) {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT162", new Object[]{this.getQualifiedName(), String.valueOf(this.getElementCount()), String.valueOf(index)});
    }

    public void createIndex(String fieldName) {
        SectionIndexImpl newIndex = new SectionIndexImpl(this, fieldName);
        if (this.sectionIndex instanceof SectionIndex.NoOpIndex) {
            this.sectionIndex = newIndex;
        } else {
            this.sectionIndex.setNextIndex(newIndex);
        }
    }

    private boolean hasElements() {
        return this.sizeImpl() > 0;
    }

    public int getElementIndex(DataObject elm) {
        int size = this.sizeImpl();
        for (int i = 0; i < size; ++i) {
            if (elm != this.getImpl(i)) continue;
            return i;
        }
        return -1;
    }

    public int getElementCount() {
        return this.sizeImpl();
    }

    public Object clone() {
        DataObjectSectionImpl clonedObject = (DataObjectSectionImpl)super.clone();
        clonedObject.size = 0;
        clonedObject.dataObject = null;
        clonedObject.elementData = null;
        clonedObject.sectionIndex = SectionIndex.NO_OP;
        if (this.hasElements()) {
            int size = this.sizeImpl();
            for (int i = 0; i < size; ++i) {
                DataObject elm = this.getImpl(i);
                DataObject clonedElement = (DataObject)elm.clone();
                clonedElement.setParentSection(clonedObject);
                clonedObject.addElement(clonedElement);
            }
        }
        return clonedObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectSectionImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataObjectSectionImpl dataObjectSection = (DataObjectSectionImpl)o;
        int size = this.getElementCount();
        if (size != dataObjectSection.getElementCount()) {
            return false;
        }
        if (this.getElementCount() == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (this.getImpl(i).equals(dataObjectSection.getImpl(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.hasElements() ? this.listHashCode() : 0);
        return result;
    }

    public Object get(int index) {
        return this.getElement(index);
    }

    public int size() {
        return this.getElementCount();
    }

    public void addElement(DataObject elm) {
        this.addElement(elm, true);
    }

    protected void addElement(DataObject elm, boolean checkParent) {
        this.addImpl(elm);
        this.sectionIndex.add(elm);
    }

    public boolean removeElement(int index) throws FieldNotFoundException {
        if (index >= 0 && index < this.size) {
            DataObject elm = this.removeImpl(index);
            this.sectionIndex.remove(elm);
            return elm != null;
        }
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT160", String.valueOf(index));
    }

    public void addAll(DataObjectSection collection) {
        try {
            for (int i = 0; i < collection.getElementCount(); ++i) {
                DataObject obj = collection.getElement(i);
                if (obj == null) continue;
                obj.setParentSection(this);
                this.addImpl(obj);
            }
            this.sectionIndex.addAll(collection);
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    public void clear() {
        this.clearImpl();
        this.sectionIndex.clear();
    }

    protected void addElement(int index, Object element) {
        this.addImpl(index, (DataObject)element);
        this.sectionIndex.add((DataObject)element);
    }

    protected void setElement(int index, Object element) {
        DataObject old = this.setImpl(index, (DataObject)element);
        if (old != null) {
            this.sectionIndex.remove(old);
        }
        this.sectionIndex.add((DataObject)element);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int size = this.sizeImpl();
        for (int i = 0; i < size; ++i) {
            s.writeObject(this.getImpl(i));
        }
        s.writeObject(this.sectionIndex);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = this.sizeImpl();
        this.size = 0;
        this.sectionIndex = SectionIndex.NO_OP;
        for (int i = 0; i < size; ++i) {
            this.addElement((DataObject)s.readObject());
        }
        this.sectionIndex = (SectionIndex)s.readObject();
    }

    private DataObject getImpl(int index) {
        this.RangeCheck(index);
        if (index == 0 && this.dataObject != null || this.elementData == null) {
            return this.dataObject;
        }
        return this.elementData[index];
    }

    private void clearImpl() {
        if (this.size > 0) {
            if (this.dataObject != null) {
                this.dataObject = null;
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.elementData[i] = null;
                }
            }
            this.size = 0;
        }
    }

    void addImpl(DataObject obj) {
        if (this.size == 0) {
            this.dataObject = obj;
            ++this.size;
        } else {
            this.promoteToArray();
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size++] = obj;
        }
    }

    private void promoteToArray() {
        if (this.elementData == null) {
            this.elementData = new DataObject[10];
        }
        if (this.dataObject != null) {
            this.elementData[0] = this.dataObject;
            this.dataObject = null;
        }
    }

    private void addImpl(int index, DataObject element) {
        if (index > this.size || index < 0) {
            this.throwIndexOutOfBounds(index);
        }
        this.promoteToArray();
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    private DataObject setImpl(int index, DataObject element) {
        this.promoteToArray();
        DataObject oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    private DataObject removeImpl(int index) {
        DataObject oldValue;
        this.RangeCheck(index);
        if (this.dataObject != null && index == 0) {
            oldValue = this.dataObject;
            this.dataObject = null;
            --this.size;
        } else {
            oldValue = this.elementData[index];
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
        }
        return oldValue;
    }

    private int listHashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            DataObject obj = this.getImpl(i);
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    private int sizeImpl() {
        return this.size;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            DataObject[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new DataObject[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            this.throwIndexOutOfBounds(index);
        }
    }

    private void throwIndexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
    }
}

