/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextBasic;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.DataObjectXMLParserImpl;
import com.tplus.transform.runtime.xml.DataObjectXMLWriter;
import com.tplus.transform.util.xml.XMLUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataObjectXML {
    protected static final String lineSeparator = "\n";
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String XML_FASTINFOSET = "xml.fastinfoset";
    private static final String XML_COMMENTS = "xml.comment";
    private static final String XML_VALUE_LINEFEED = "xml.value.linefeed";

    private static String indentStr(int val) {
        return fullindent.substring(0, val);
    }

    private DataObjectXML() {
    }

    public static byte[] serialize(DataObject dataObj) {
        String str = DataObjectXML.toXMLString(dataObj, 1);
        try {
            return CharBinaryBuffer.stringToBytes(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    public static String serializeToString(DataObject dataObj) {
        String str = DataObjectXML.toXMLString(dataObj, 1);
        return str;
    }

    public static String toXMLString(DataObject dataObj) {
        DataObjectXMLWriter writer = new DataObjectXMLWriter();
        return (String)writer.toXMLString(dataObj);
    }

    public static String toXMLString(DataObject dataObj, int indent) {
        DataObjectXMLWriter writer = new DataObjectXMLWriter();
        return (String)writer.toXMLString(dataObj, indent, true);
    }

    public static String toXMLString(DataObject dataObj, int indent, boolean addXMLDecl) {
        DataObjectXMLWriter writer = new DataObjectXMLWriter();
        return (String)writer.toXMLString(dataObj, indent, addXMLDecl);
    }

    public static String toXMLString(DataObjectSection sec, int indent) {
        try {
            DataObjectXMLWriter writer = new DataObjectXMLWriter();
            return (String)writer.toXMLString(sec, indent, null);
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    public static String toXMLString(DataObjectMetaInfo dataMetaInfo) {
        return DataObjectXML.toXMLString(dataMetaInfo, 1, true);
    }

    static String toXMLString(DataObjectMetaInfo dataMetaInfo, int indent) {
        return DataObjectXML.toXMLString(dataMetaInfo, indent, true);
    }

    static String toXMLString(DataObjectMetaInfo dataMetaInfo, int indent, boolean wrapRootSection) {
        if (indent < 1) {
            throw StandardRuntimeResource.createIllegalArgumentExceptionFormatted("SRT153");
        }
        FastStringBuffer toRet = new FastStringBuffer();
        if (wrapRootSection && dataMetaInfo.getParentSection() == null) {
            toRet.append(DataObjectXML.indentStr(indent - 1)).append("<").append(dataMetaInfo.getName()).append(">");
            toRet.append(lineSeparator);
        }
        int count = dataMetaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            try {
                FieldMetaInfo fieldInfo = dataMetaInfo.getFieldMetaInfo(i);
                toRet.append(DataObjectXML.startTag(indent, "field"));
                toRet.append(DataObjectXML.tagValue(++indent, "name", fieldInfo.getName()));
                toRet.append(DataObjectXML.tagValue(indent, "type", fieldInfo.getType()));
                if (fieldInfo.isSynthesized()) {
                    toRet.append(DataObjectXML.tagValue(indent, "synthesized", "true"));
                }
                if (fieldInfo instanceof SectionMetaInfo) {
                    SectionMetaInfo sectionInfo = (SectionMetaInfo)fieldInfo;
                    if (sectionInfo.getMinOccurs() > 0) {
                        toRet.append(DataObjectXML.tagValue(indent, "minoccurs", Parsing.toString(sectionInfo.getMinOccurs())));
                    }
                    if (sectionInfo.getMaxOccurs() != -1) {
                        toRet.append(DataObjectXML.tagValue(indent, "maxoccurs", Parsing.toString(sectionInfo.getMaxOccurs())));
                    }
                    toRet.append(DataObjectXML.toXMLString(sectionInfo.getDataObjectMetaInfo(), indent + 1, false));
                } else {
                    toRet.append(DataObjectXML.tagValue(indent, "optional", "" + fieldInfo.isOptional()));
                }
                toRet.append(DataObjectXML.endTag(--indent, "field"));
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
        if (wrapRootSection && dataMetaInfo.getParentSection() == null) {
            toRet.append(DataObjectXML.indentStr(indent - 1)).append("</").append(dataMetaInfo.getName()).append(">");
            toRet.append(lineSeparator);
        }
        return toRet.toString();
    }

    static String toValueString(String value) {
        if (value == null) {
            return "";
        }
        return XMLUtils.fixXMLCharData(value);
    }

    static final String fixXMLAttribute(String str) {
        return XMLUtils.fixXMLAttribute(str);
    }

    static String tagValue(int indent, String tagName, String value) {
        if (value != null) {
            return DataObjectXML.indentStr(indent) + "<" + tagName + ">" + DataObjectXML.toValueString(value) + "</" + tagName + ">" + lineSeparator;
        }
        return "";
    }

    static String startTag(int indent, String tagName) {
        return DataObjectXML.indentStr(indent) + "<" + tagName + ">" + lineSeparator;
    }

    static String endTag(int indent, String tagName) {
        return DataObjectXML.indentStr(indent) + "</" + tagName + ">" + lineSeparator;
    }

    public static final void write(DataObject obj, Writer writer) throws IOException {
        BufferedWriter bos = new BufferedWriter(writer);
        bos.write(DataObjectXML.toXMLString(obj));
        bos.flush();
    }

    public static final void read(DataObject obj, InputStream is) throws TransformException {
        DataObjectXML.fromXML(obj, is);
    }

    public static final void parse(DataObject obj, byte[] bytes) throws TransformException {
        DataObjectXML.fromXML(obj, bytes);
    }

    public static final void parse(DataObject obj, String str) throws TransformException {
        DataObjectXML.fromXML(obj, new StringReader(str));
    }

    public static final void fromXML(DataObject obj, InputSource is) throws TransformException {
        DataObjectXML.fromXML(obj, is.getAsStream());
    }

    public static final void fromXML(DataObject obj, byte[] bytes) throws TransformException {
        DataObjectXML.fromXML(obj, new ByteArrayInputStream(bytes));
    }

    public static final void fromXML(DataObject obj, Reader in) throws TransformException {
        DataObjectXMLParserImpl dataObjectXMLParser = new DataObjectXMLParserImpl();
        dataObjectXMLParser.parse(obj, in, (TransformContext)new TransformContextBasic());
    }

    public static final void fromXML(DataObject obj, InputStream in) throws TransformException {
        DataObjectXMLParserImpl dataObjectXMLParser = new DataObjectXMLParserImpl();
        dataObjectXMLParser.parse(obj, in, (TransformContext)new TransformContextBasic());
    }

    public static void fromMap(DataObject dataObj, Map map) throws TransformException {
        if (map == null) {
            map = new HashMap();
        }
        DataObjectMetaInfo metaInfo = dataObj.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            List sectionList;
            FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
            String name = fieldMetaInfo.getName();
            String mangledName = fieldMetaInfo.getMangledName();
            DesignerType type = fieldMetaInfo.getDesignerType();
            Object obj = map.get(name);
            if (obj == null) {
                obj = map.get(mangledName);
            }
            if (type.isSectionType()) {
                DataObjectSection sec = dataObj.getSection(i);
                sec.clear();
                if (obj instanceof List) {
                    sectionList = (List)obj;
                    DataObjectXML.fromList(sec, sectionList);
                    continue;
                }
                if (obj instanceof String && ((String)obj).trim().length() == 0) {
                    sec.addElement(sec.createElement());
                    continue;
                }
                if (obj == null) continue;
                throw TransformException.createFormatted("SRT175", new Object[]{name, obj});
            }
            if (type.isMessageType()) {
                DataObject newElement = (DataObject)dataObj.getField(fieldMetaInfo.getIndex());
                if (newElement != null) {
                    newElement.reset();
                } else {
                    newElement = dataObj.createSectionElement(fieldMetaInfo.getIndex(), null);
                }
                if (obj instanceof List) {
                    sectionList = (List)obj;
                    if (sectionList.size() > 0) {
                        DataObjectXML.fromMap(newElement, (Map)sectionList.get(0));
                    }
                } else if (!(obj instanceof String && ((String)obj).trim().length() == 0 || obj == null)) {
                    throw TransformException.createFormatted("SRT175", new Object[]{name, obj});
                }
                dataObj.setField(i, (Object)newElement);
                continue;
            }
            if (obj instanceof String) {
                String value = (String)obj;
                try {
                    Object runtimeObj = type.parse(value);
                    dataObj.setField(i, runtimeObj);
                    continue;
                }
                catch (TransformException e) {
                    e.setFieldName(dataObj.getQualifiedName(i));
                    throw e;
                }
                catch (Exception e) {
                    TransformException te = TransformException.createFormatted("SRT176");
                    te.setFieldName(dataObj.getQualifiedName(i));
                    te.setDetail(e);
                    throw te;
                }
            }
            dataObj.setNull(i);
        }
    }

    public static void fromList(DataObjectSection section, List list) throws TransformException {
        section.clear();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            if (map == null) continue;
            DataObject obj = section.createElement();
            DataObjectXML.fromMap(obj, map);
            section.addElement(obj);
        }
    }

    public static boolean isCommentsEnabled(TransformContext tcxt) {
        String value;
        return tcxt != null && (value = (String)tcxt.getProperty(XML_COMMENTS)) != null && value.equalsIgnoreCase("true");
    }

    public static String getLineFeed(TransformContext tcxt) {
        if (tcxt != null) {
            String value = (String)tcxt.getProperty(XML_VALUE_LINEFEED);
            return value;
        }
        return null;
    }

    public static boolean isFastInfoSet(TransformContext tcxt) {
        String value;
        return tcxt != null && (value = (String)tcxt.getProperty(XML_FASTINFOSET)) != null && value.equalsIgnoreCase("true");
    }
}

