/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractPersistenceManager;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.util.sql.SQLType;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public class DatabaseFieldMetaInfo
extends FieldMetaInfoImpl {
    boolean primaryKey;
    boolean autoGenerate;
    SQLType sqlType;
    int length;
    int decimalLength;
    boolean xmlField;
    private String normalizedFieldName;

    public DatabaseFieldMetaInfo(String columnName, SQLType sqlType, String normalizedFieldName, DesignerType designerType, boolean optional) {
        super(columnName, designerType, optional);
        this.sqlType = sqlType;
        this.normalizedFieldName = normalizedFieldName;
    }

    public DatabaseFieldMetaInfo setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public DatabaseFieldMetaInfo setAutoGenerate(boolean autoGenerate) {
        this.autoGenerate = autoGenerate;
        return this;
    }

    public String getNormalizedFieldName() {
        return this.normalizedFieldName;
    }

    public SQLType getSQLType() {
        return this.sqlType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }

    public boolean isXmlField() {
        return this.xmlField;
    }

    public Object normalizedValueToDBValue(Object value) {
        return DatabaseFieldMetaInfo.toSQLType(value, this.getDesignerType(), this.getSQLType().getSQLType());
    }

    public static Object toSQLType(Object value, DesignerType designerType, int sqlType) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return value;
            }
            case -5: {
                if (designerType == DesignerTypes.BIG_INTEGER_TYPE) {
                    return AbstractPersistenceManager.toBigDecimal((BigInteger)value);
                }
                return value;
            }
            case -4: 
            case -3: 
            case -2: {
                return value;
            }
            case 2004: {
                return value;
            }
            case 1: {
                return AbstractPersistenceManager.toSQLChar((Character)value);
            }
            case 91: {
                if (DatabaseFieldMetaInfo.isDateType(designerType)) {
                    return AbstractPersistenceManager.toSQLDate((Date)value);
                }
                if (!DatabaseFieldMetaInfo.isISODateType(designerType)) break;
                return AbstractPersistenceManager.toSQLDate((Calendar)value);
            }
            case 92: {
                if (DatabaseFieldMetaInfo.isDateType(designerType)) {
                    return AbstractPersistenceManager.toSQLTime((Date)value);
                }
                if (!DatabaseFieldMetaInfo.isISODateType(designerType)) break;
                return AbstractPersistenceManager.toSQLTime((Calendar)value);
            }
            case 93: {
                if (DatabaseFieldMetaInfo.isDateType(designerType)) {
                    return AbstractPersistenceManager.toSQLTimestamp((Date)value);
                }
                if (!DatabaseFieldMetaInfo.isISODateType(designerType)) break;
                return AbstractPersistenceManager.toSQLTimestamp((Calendar)value);
            }
        }
        return null;
    }

    private static boolean isDateType(DesignerType designerType) {
        return designerType == DesignerTypes.DATE_ONLY_TYPE || designerType == DesignerTypes.DATE_TIME_TYPE || designerType == DesignerTypes.TIME_ONLY_TYPE;
    }

    private static boolean isISODateType(DesignerType designerType) {
        return designerType == DesignerTypes.ISO_DATE_TYPE || designerType == DesignerTypes.ISO_DATE_TIME_TYPE || designerType == DesignerTypes.ISO_TIME_TYPE;
    }
}

