/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DatabaseFieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.QueryDef;
import com.tplus.transform.runtime.QueryDefImpl;
import com.tplus.transform.runtime.TransformException;
import java.util.HashMap;
import java.util.Map;

public class DatabaseMetaInfo
extends DataObjectMetaInfoImpl {
    Map queries = new HashMap();
    protected String dataSourceName = "transformdb";
    protected String uniqueKeyGenTableName = "UniqueKeyGenTable";

    public DatabaseMetaInfo(String name, FieldMetaInfo[] fields) {
        super(name, fields);
    }

    public void addQuery(QueryDef def) {
        this.queries.put(def.getName(), def);
    }

    QueryDefImpl getQueryImpl(String name) throws TransformException {
        QueryDefImpl def = (QueryDefImpl)this.queries.get(name);
        if (def == null) {
            throw TransformException.createFormatted("SRT225", name);
        }
        return def;
    }

    public QueryDef[] getQueries() {
        return this.queries.values().toArray(new QueryDef[this.queries.size()]);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getUniqueKeyGenTableName() {
        return this.uniqueKeyGenTableName;
    }

    public void setUniqueKeyGenTableName(String uniqueKeyGenTableName) {
        this.uniqueKeyGenTableName = uniqueKeyGenTableName;
    }

    public String generateInsertStatement() {
        StringBuffer namesStr = new StringBuffer();
        StringBuffer valuesStr = new StringBuffer();
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo info = this.getFieldMetaInfo(i);
            if (!(info instanceof DatabaseFieldMetaInfo)) continue;
            DatabaseFieldMetaInfo metaInfo = (DatabaseFieldMetaInfo)info;
            if (i > 0) {
                namesStr.append(", ");
                valuesStr.append(", ");
            }
            namesStr.append(metaInfo.getName());
            valuesStr.append("?");
        }
        StringBuffer buf = new StringBuffer("insert into ").append(this.getName());
        buf.append(" (").append(namesStr.toString()).append(")");
        buf.append(" Values(").append(valuesStr.toString()).append(")");
        return buf.toString();
    }

    public String toAllFieldsStr(String tableAliasName) {
        StringBuffer toRet = new StringBuffer(100);
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo metaInfo = this.getFieldMetaInfo(i);
            if (!(metaInfo instanceof DatabaseFieldMetaInfo)) continue;
            DatabaseFieldMetaInfo info = (DatabaseFieldMetaInfo)metaInfo;
            String allField = info.getName();
            if (toRet.length() > 0) {
                toRet.append(',');
            }
            toRet.append(tableAliasName).append('.').append(allField);
        }
        return toRet.toString();
    }

    public DatabaseFieldMetaInfo getDataFieldForNormalizedField(String noFieldName) {
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            DatabaseFieldMetaInfo info;
            FieldMetaInfo metaInfo = this.getFieldMetaInfo(i);
            if (!(metaInfo instanceof DatabaseFieldMetaInfo) || !(info = (DatabaseFieldMetaInfo)metaInfo).getNormalizedFieldName().equals(noFieldName)) continue;
            return info;
        }
        return null;
    }
}

