/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.RawInputMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.cache.Map;
import com.tplus.transform.runtime.collection.ValueList;
import com.tplus.transform.runtime.collection.VariantList;
import com.tplus.transform.runtime.formula.FormatFunctions;
import com.tplus.transform.util.CalendarFormatter;
import com.tplus.transform.util.CalendarParser;
import com.tplus.transform.util.EnumObject;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class DesignerType
extends Type {
    Class valueClass;
    Class valueListClass;
    Class valueObjectClass;
    private static final EnumObject.EnumClassObjectInfo objInfo = new EnumObject.EnumClassObjectInfo(DesignerType.class);
    public static final DesignerType DESIGNER_STRING_TYPE = new DesignerStringType();
    public static final DesignerType DESIGNER_INT_TYPE = new DesignerIntegerType();
    public static final DesignerType DESIGNER_CHAR_TYPE = new DesignerCharacterType();
    public static final DesignerType DESIGNER_FLOAT_TYPE = new DesignerFloatType();
    public static final DesignerType DESIGNER_DOUBLE_TYPE = new DesignerDoubleType();
    public static final DesignerType DESIGNER_LONG_TYPE = new DesignerLongType();
    public static final DesignerType DESIGNER_BOOLEAN_TYPE = new DesignerBooleanType();
    public static final DesignerType DESIGNER_DATE_TIME_TYPE = new DesignerDateTimeType();
    public static final DesignerType DESIGNER_TIME_ONLY_TYPE = new DesignerTimeOnlyType();
    public static final DesignerType DESIGNER_DATE_ONLY_TYPE = new DesignerDateOnlyType();
    public static final AbstractDesignerISODateType DESIGNER_ISO_DATE_TIME_TYPE = new DesignerISODateTimeType();
    public static final AbstractDesignerISODateType DESIGNER_ISO_TIME_TYPE = new DesignerISOTimeType();
    public static final AbstractDesignerISODateType DESIGNER_ISO_DATE_TYPE = new DesignerISODateType();
    public static final DesignerType DESIGNER_BINARY_TYPE = new DesignerBinaryType();
    public static final DesignerType DESIGNER_RAW_MESSAGE_TYPE = new DesignerRawMessageType();
    public static final DesignerType DESIGNER_BIG_INT_TYPE = new DesignerBigIntegerType();
    public static final DesignerType DESIGNER_BIG_DECIMAL_TYPE = new DesignerBigDecimalType();
    public static final DesignerType DESIGNER_SCALED_DECIMAL_TYPE = new DesignerScaledDecimalType();
    public static final DesignerType DESIGNER_SECTION_TYPE = new DesignerSectionType();
    public static final DesignerType DESIGNER_DATAOBJECT_TYPE = new DesignerDataObjectType();
    public static final DesignerType DESIGNER_OBJECT_TYPE = new DesignerObjectType();
    public static final DesignerType MAP_TYPE = new DesignerMapType();
    public static final DesignerListType DESIGNER_STRING_LIST_TYPE = new DesignerListType(DESIGNER_STRING_TYPE);
    public static final DesignerListType DESIGNER_INT_LIST_TYPE = new DesignerListType(DESIGNER_INT_TYPE);
    public static final DesignerListType DESIGNER_CHAR_LIST_TYPE = new DesignerListType(DESIGNER_CHAR_TYPE);
    public static final DesignerListType DESIGNER_FLOAT_LIST_TYPE = new DesignerListType(DESIGNER_FLOAT_TYPE);
    public static final DesignerListType DESIGNER_DOUBLE_LIST_TYPE = new DesignerListType(DESIGNER_DOUBLE_TYPE);
    public static final DesignerListType DESIGNER_LONG_LIST_TYPE = new DesignerListType(DESIGNER_LONG_TYPE);
    public static final DesignerListType DESIGNER_BOOLEAN_LIST_TYPE = new DesignerListType(DESIGNER_BOOLEAN_TYPE);
    public static final DesignerListType DESIGNER_DATE_TIME_LIST_TYPE = new DesignerListType(DESIGNER_DATE_TIME_TYPE);
    public static final DesignerListType DESIGNER_TIME_ONLY_LIST_TYPE = new DesignerListType(DESIGNER_TIME_ONLY_TYPE);
    public static final DesignerListType DESIGNER_DATE_ONLY_LIST_TYPE = new DesignerListType(DESIGNER_DATE_ONLY_TYPE);
    public static final DesignerListType DESIGNER_ISO_DATE_TIME_LIST_TYPE = new DesignerListType(DESIGNER_ISO_DATE_TIME_TYPE);
    public static final DesignerListType DESIGNER_ISO_TIME_LIST_TYPE = new DesignerListType(DESIGNER_ISO_TIME_TYPE);
    public static final DesignerListType DESIGNER_ISO_DATE_LIST_TYPE = new DesignerListType(DESIGNER_ISO_DATE_TYPE);
    public static final DesignerListType DESIGNER_BINARY_LIST_TYPE = new DesignerListType(DESIGNER_BINARY_TYPE);
    public static final DesignerListType DESIGNER_RAW_MESSAGE_LIST_TYPE = new DesignerListType(DESIGNER_RAW_MESSAGE_TYPE);
    public static final DesignerListType DESIGNER_BIG_INT_LIST_TYPE = new DesignerListType(DESIGNER_BIG_INT_TYPE);
    public static final DesignerListType DESIGNER_BIG_DECIMAL_LIST_TYPE = new DesignerListType(DESIGNER_BIG_DECIMAL_TYPE);
    public static final DesignerListType DESIGNER_SCALED_DECIMAL_LIST_TYPE = new DesignerListType(DESIGNER_SCALED_DECIMAL_TYPE);
    public static final DesignerListType DESIGNER_OBJECT_LIST_TYPE = new DesignerListType(DESIGNER_OBJECT_TYPE);

    protected DesignerType(String name, Class valueClass, Class valueObjectClass) {
        this(name, valueClass, valueObjectClass, name + "List");
    }

    protected DesignerType(String name, Class valueClass, Class valueObjectClass, String listClassName) {
        this(name, valueClass, valueObjectClass, DesignerType.listClass(listClassName));
    }

    protected DesignerType(String name, Class valueClass, Class valueObjectClass, Class valueListClass) {
        super(name);
        this.valueClass = valueClass;
        this.valueListClass = valueListClass;
        this.valueObjectClass = valueObjectClass;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public Class getValueListClass() {
        return this.valueListClass;
    }

    public List createValueList() {
        try {
            return (List)this.valueListClass.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new UnknownError("");
    }

    public Class getValueObjectClass() {
        return this.valueObjectClass;
    }

    public boolean isValueAssignable(Object value) {
        if (value == null) {
            return true;
        }
        return this.valueObjectClass.isInstance(value);
    }

    public static DesignerType[] values() {
        return (DesignerType[])objInfo.values();
    }

    public static String[] names() {
        return objInfo.names();
    }

    public static DesignerType valueOf(String name) {
        return (DesignerType)objInfo.valueOf(name);
    }

    public static DesignerType valueOf(int ordinal) {
        return (DesignerType)objInfo.valueOf(ordinal);
    }

    public abstract Object parse(String var1) throws TransformException;

    public Object parse(String str, String pattern) throws TransformException {
        return this.parse(str);
    }

    public abstract String format(Object var1);

    public String format(Object obj, String pattern) {
        return this.format(obj);
    }

    protected void throwConversionException(String str) throws TransformException {
        throw TransformException.createFormattedWithValue("SRT127", new Object[]{str, this}, str);
    }

    protected void throwConversionException(String str, String format) throws TransformException {
        throw TransformException.createFormattedWithValue("SRT127", new Object[]{str, this}, str);
    }

    protected void throwIllegalStringConversionException(Object obj) {
        throw StandardRuntimeResource.createIllegalArgumentExceptionFormatted("SRT127", new Object[]{obj, this.toString()});
    }

    protected EnumObject.EnumClassObjectInfo getEnumClassObjectInfo() {
        return objInfo;
    }

    public boolean isPrimitiveType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isSectionType() {
        return false;
    }

    public boolean isMessageType() {
        return false;
    }

    public abstract boolean isValidValue(String var1, String var2);

    public boolean isNumeric() {
        return false;
    }

    public boolean isAssignableFrom(DesignerType srcType) {
        return this.equals(srcType);
    }

    public boolean isValidFormat(String parsingFormat) throws IllegalArgumentException {
        return true;
    }

    public String getDefaultFormat() {
        throw StandardRuntimeResource.createIllegalArgumentExceptionFormatted("SRT138", new Object[]{this});
    }

    private static String formatCompatMode(Date date) {
        String format = "yyyyMMdd";
        if (date.getYear() == 70 && date.getMonth() == 0 && date.getDate() == 1) {
            format = "HH:mm:ss";
        } else if (date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0) {
            format = "yyyyMMdd-HH:mm:ss.SSS";
        }
        return Parsing.formatDate(date, format);
    }

    private static Object parseCompatMode(String str) throws FieldParsingException {
        String format = "yyyyMMdd";
        if (str.indexOf(58) != -1) {
            format = "HH:mm:ss";
            if (str.indexOf(45) != -1) {
                format = "yyyyMMdd-HH:mm:ss.SSS";
            }
        }
        try {
            return Parsing.parseDate(str, format);
        }
        catch (FieldParsingException parse) {
            return Parsing.parseDate(str, "yyyyMMdd");
        }
    }

    private static Class listClass(String name) {
        try {
            Class<?> cls = Class.forName("com.tplus.transform.runtime.collection." + name);
            return cls;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static class DesignerListType
    extends DesignerType {
        private DesignerType componentType;

        public DesignerListType(DesignerType componentType) {
            super(componentType.getName() + "List", componentType.getValueListClass(), componentType.getValueListClass(), (Class)null);
            this.componentType = componentType;
        }

        public Object parse(String str) throws TransformException {
            List valueList = this.componentType.createValueList();
            if (str != null) {
                if ((str = str.trim()).startsWith("[")) {
                    str = str.substring(1);
                }
                if (str.endsWith("]")) {
                    str = str.substring(0, str.length() - 1);
                }
                String[] strings = StringUtils.split(str, ",");
                for (int i = 0; i < strings.length; ++i) {
                    String string = strings[i];
                    Object o = this.componentType.parse(string.trim());
                    valueList.add(o);
                }
            }
            return valueList;
        }

        public String format(Object obj) {
            ValueList v = (ValueList)obj;
            StringBuffer buf = new StringBuffer();
            int size = v.size();
            buf.append("[");
            for (int i = 0; i < size; ++i) {
                Object value = v.get(i);
                buf.append(this.componentType.format(value));
                if (i >= size - 1) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public DesignerType getComponentType() {
            return this.componentType;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isSectionType() {
            return false;
        }

        public boolean isListType() {
            return true;
        }
    }

    private static class DesignerVariantType
    extends DesignerType {
        public DesignerVariantType() {
            super("Object", Variant.class, Variant.class, VariantList.class);
        }

        public Object parse(String str) throws TransformException {
            this.throwConversionException(str);
            return null;
        }

        public String format(Object obj) {
            this.throwIllegalStringConversionException("" + obj);
            return null;
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMessageType() {
            return true;
        }
    }

    private static class DesignerMapType
    extends DesignerType {
        public DesignerMapType() {
            super("Map", Map.class, Map.class, VariantList.class);
        }

        public Object parse(String str) throws TransformException {
            throw new TransformException("Not supported");
        }

        public String format(Object obj) {
            return obj.toString();
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMessageType() {
            return false;
        }
    }

    private static class DesignerObjectType
    extends DesignerType {
        public DesignerObjectType() {
            super("Object", Variant.class, Variant.class, VariantList.class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.toVariant(str);
        }

        public String format(Object obj) {
            Variant variant = (Variant)obj;
            DesignerType type = variant.getType();
            return type.format(variant.getValue());
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMessageType() {
            return true;
        }
    }

    private static class DesignerDataObjectType
    extends DesignerType {
        public DesignerDataObjectType() {
            super("DataObject", DataObject.class, DataObject.class, DataObjectSection.class);
        }

        public Object parse(String str) throws TransformException {
            this.throwConversionException(str);
            return null;
        }

        public String format(Object obj) {
            DataObject dataObject = (DataObject)obj;
            return dataObject.toString();
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMessageType() {
            return true;
        }
    }

    private static class DesignerSectionType
    extends DesignerType {
        public DesignerSectionType() {
            super("Section", DataObjectSection.class, DataObjectSection.class, DataObjectSection.class);
        }

        public Object parse(String str) throws TransformException {
            this.throwConversionException(str);
            return null;
        }

        public String format(Object obj) {
            if (obj instanceof DataObjectSection) {
                DataObjectSection dataObjectSection = (DataObjectSection)obj;
                return dataObjectSection.toXMLString();
            }
            if (obj instanceof DataObject) {
                DataObject dataObject = (DataObject)obj;
                return dataObject.toXMLString();
            }
            this.throwIllegalStringConversionException("");
            return null;
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isSectionType() {
            return true;
        }
    }

    private static class DesignerISODateType
    extends AbstractDesignerISODateType {
        public static final String FORMAT = "%Y-%M-%D%z";

        public DesignerISODateType() {
            super("ISODate", Calendar.class, Calendar.class);
        }

        public Object parse0(String str) throws TransformException {
            return Parsing.parseISODate(str);
        }

        public String format(Object obj) {
            return Parsing.formatISODate((Calendar)obj);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }
    }

    private static class DesignerISOTimeType
    extends AbstractDesignerISODateType {
        public static final String FORMAT = "%h:%m:%s%z";

        public DesignerISOTimeType() {
            super("ISOTime", Calendar.class, Calendar.class);
        }

        public Object parse0(String str) throws TransformException {
            return Parsing.parseISOTime(str);
        }

        public String format(Object obj) {
            return Parsing.formatISOTime((Calendar)obj);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }
    }

    private static class DesignerISODateTimeType
    extends AbstractDesignerISODateType {
        public static final String FORMAT = "%Y-%M-%DT%h:%m:%s%z";

        public DesignerISODateTimeType() {
            super("ISODateTime", Calendar.class, Calendar.class);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }

        public Object parse0(String str) throws FieldParsingException {
            return Parsing.parseISODateTime(str);
        }

        public String format(Object obj) {
            return Parsing.formatISODateTime((Calendar)obj);
        }
    }

    private static class DesignerTimeOnlyType
    extends AbstractDesignerDateType {
        public static final String FORMAT = "%h:%m:%s";

        public DesignerTimeOnlyType() {
            super("TimeOnly", Date.class, Date.class);
        }

        public Object parse0(String str) throws TransformException {
            return Parsing.parseISOTimeAsDate(str);
        }

        public String format(Object obj) {
            Date date = (Date)obj;
            return Parsing.formatISOTime(date);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }
    }

    private static class DesignerDateOnlyType
    extends AbstractDesignerDateType {
        public static final String FORMAT = "%Y-%M-%D";

        public DesignerDateOnlyType() {
            super("DateOnly", Date.class, Date.class);
        }

        public Object parse0(String str) throws TransformException {
            return Parsing.parseISODateAsDate(str);
        }

        public String format(Object obj) {
            Date date = (Date)obj;
            return Parsing.formatISODate(date);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }
    }

    private static class DesignerDateTimeType
    extends AbstractDesignerDateType {
        public static final String FORMAT = "%Y-%M-%DT%h:%m:%s";

        public DesignerDateTimeType() {
            super("DateTime", Date.class, Date.class);
        }

        public Object parse0(String str) throws TransformException {
            try {
                return Parsing.parseISODateTimeAsDate(str);
            }
            catch (IllegalArgumentException e) {
                try {
                    return DesignerType.parseCompatMode(str);
                }
                catch (FieldParsingException ex) {
                    throw e;
                }
            }
        }

        public String format(Object obj) {
            Date date = (Date)obj;
            return Parsing.formatISODateTime(date);
        }

        public String getDefaultFormat() {
            return FORMAT;
        }
    }

    private static class DesignerBooleanType
    extends DesignerType {
        public DesignerBooleanType() {
            super("Boolean", Boolean.TYPE, Boolean.class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
        }

        public String format(Object obj) {
            return obj.toString();
        }

        public boolean isValidValue(String value, String format) {
            return value.equals("true") || value.equals("false");
        }
    }

    private static class DesignerDoubleType
    extends DesignerType {
        public DesignerDoubleType() {
            super("Double", Double.TYPE, Double.class);
        }

        public Object parse(String str, String pattern) throws TransformException {
            if (pattern == null) {
                return this.parse(str);
            }
            NumberFormat numberFormat = this.getNumberFormat(pattern);
            try {
                Number number = numberFormat.parse(str);
                return new Double(number.doubleValue());
            }
            catch (ParseException e) {
                throw new TransformException("Error parsing double value " + str, e);
            }
        }

        private NumberFormat getNumberFormat(String pattern) {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)format;
                decimalFormat.applyPattern(pattern);
            }
            return format;
        }

        public Object parse(String str) throws TransformException {
            try {
                return new Double(Double.parseDouble(str));
            }
            catch (NumberFormatException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        public String format(Object obj, String pattern) {
            if (pattern == null) {
                return this.format(obj);
            }
            NumberFormat numberFormat = this.getNumberFormat(pattern);
            Number number = (Number)obj;
            return numberFormat.format(number.doubleValue());
        }

        public String format(Object obj) {
            Number number = (Number)obj;
            return Parsing.toString(number.doubleValue());
        }

        public boolean isValidValue(String value, String format) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType) || DESIGNER_FLOAT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    }

    private static class DesignerFloatType
    extends DesignerType {
        public DesignerFloatType() {
            super("Float", Float.TYPE, Float.class);
        }

        public Object parse(String str) throws TransformException {
            try {
                return new Float(Float.parseFloat(str));
            }
            catch (NumberFormatException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        public String format(Object obj) {
            Number number = (Number)obj;
            return Parsing.toString(number.floatValue());
        }

        public boolean isValidValue(String value, String format) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    }

    private static class DesignerBigDecimalType
    extends DesignerType {
        public DesignerBigDecimalType() {
            super("BigDecimal", BigDecimal.class, BigDecimal.class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseBigDecimal(str.trim());
        }

        public String format(Object obj) {
            return Parsing.formatBigDecimal((BigDecimal)obj);
        }

        public String format(Object obj, String format) {
            if (format != null) {
                return Parsing.formatBigDecimal((BigDecimal)obj, format);
            }
            return this.format(obj);
        }

        public boolean isValidValue(String value, String format) {
            try {
                new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isNumeric() {
            return true;
        }
    }

    private static class DesignerScaledDecimalType
    extends DesignerType {
        public DesignerScaledDecimalType() {
            super("ScaledDecimal", ScaledDecimal.class, ScaledDecimal.class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseScaledDecimal(str.trim());
        }

        public String format(Object obj) {
            return Parsing.formatScaledDecimal((ScaledDecimal)obj);
        }

        public boolean isNumeric() {
            return true;
        }

        public boolean isValidValue(String value, String format) {
            try {
                new ScaledDecimal(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
    }

    private static class DesignerBigIntegerType
    extends DesignerType {
        public DesignerBigIntegerType() {
            super("BigInteger", BigInteger.class, BigInteger.class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseBigInteger(str.trim());
        }

        public boolean isNumeric() {
            return true;
        }

        public String format(Object obj) {
            return Parsing.formatBigInteger((BigInteger)obj);
        }

        public boolean isValidValue(String value, String format) {
            try {
                new BigInteger(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
    }

    private static class DesignerLongType
    extends DesignerType {
        public DesignerLongType() {
            super("Long", Long.TYPE, Long.class);
        }

        public Object parse(String str) throws TransformException {
            try {
                return Wrapper.box(Wrapper.parseLong(str));
            }
            catch (NumberFormatException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        public String format(Object obj) {
            return obj.toString();
        }

        public boolean isValidValue(String value, String format) {
            try {
                Wrapper.parseLong(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    }

    private static class DesignerIntegerType
    extends DesignerType {
        public DesignerIntegerType() {
            super("Integer", Integer.TYPE, Integer.class, "IntList");
        }

        public Object parse(String str) throws TransformException {
            try {
                return Wrapper.box(Wrapper.parseInt(str));
            }
            catch (NumberFormatException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        public String format(Object obj) {
            return obj.toString();
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public boolean isNumeric() {
            return true;
        }
    }

    private static class DesignerCharacterType
    extends DesignerType {
        public DesignerCharacterType() {
            super("Character", Character.TYPE, Character.class, "CharList");
        }

        public Object parse(String str) throws TransformException {
            if (str.length() == 1) {
                return Wrapper.box(str.charAt(0));
            }
            this.throwConversionException(str);
            return null;
        }

        public String format(Object obj) {
            return obj.toString();
        }

        public boolean isValidValue(String value, String format) {
            return value.length() == 1;
        }
    }

    private static class DesignerStringType
    extends DesignerType {
        public DesignerStringType() {
            super("String", String.class, String.class);
        }

        public Object parse(String str) throws TransformException {
            return str;
        }

        public String format(Object obj) {
            return (String)obj;
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }
    }

    private static class DesignerRawMessageType
    extends DesignerType {
        public DesignerRawMessageType() {
            super("RawMessage", RawMessage[].class, RawMessage[].class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseBinary(str);
        }

        public String format(Object obj) {
            RawInputMessage value = (RawInputMessage)obj;
            try {
                return Parsing.formatBinary(value.getAsBytes());
            }
            catch (TransformException transformException) {
                return "";
            }
        }

        public boolean isValidValue(String value, String format) {
            for (int i = 0; i < value.length(); ++i) {
                char c = Character.toUpperCase(value.charAt(i));
                if (Character.isDigit(c) || c >= 'A' && c <= 'F') continue;
                return false;
            }
            return true;
        }
    }

    private static class DesignerBinaryType
    extends DesignerType {
        public DesignerBinaryType() {
            super("Binary", byte[].class, byte[].class);
        }

        public Object parse(String str) throws TransformException {
            return Parsing.parseBinary(str);
        }

        public String format(Object obj) {
            byte[] value = (byte[])obj;
            return Parsing.formatBinary(value);
        }

        public boolean isValidValue(String value, String format) {
            for (int i = 0; i < value.length(); ++i) {
                char c = Character.toUpperCase(value.charAt(i));
                if (Character.isDigit(c) || c >= 'A' && c <= 'F') continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class AbstractDesignerISODateType
    extends DesignerType {
        protected AbstractDesignerISODateType(String name, Class valueClass, Class valueObjectClass) {
            super(name, valueClass, valueObjectClass, "CalendarList");
        }

        public Object parse(String str) throws TransformException {
            try {
                return this.parse0(str);
            }
            catch (TransformRuntimeException e) {
                this.throwConversionException(str);
                return null;
            }
            catch (IllegalArgumentException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        public Object parse(String str, String pattern) throws TransformException {
            if (pattern == null) {
                return this.parse(str);
            }
            try {
                return FormatFunctions.parseISODate(str, pattern);
            }
            catch (TransformRuntimeException e) {
                this.throwConversionException(e.getMessage(), pattern);
                return null;
            }
        }

        public String format(Object obj, String pattern) {
            if (pattern == null) {
                return this.format(obj);
            }
            Calendar date = (Calendar)obj;
            return Parsing.formatISODate(date, pattern);
        }

        protected abstract Object parse0(String var1) throws TransformException;

        public abstract String getDefaultFormat();

        public boolean isValidValue(String value, String format) {
            try {
                AbstractDesignerISODateType.parseISODate(format, value);
            }
            catch (TransformRuntimeException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }

        public static Calendar parseISODate(String arg, String format) throws IllegalArgumentException {
            return CalendarParser.parse(format, arg);
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return srcType instanceof AbstractDesignerISODateType;
        }

        public static String formatISODate(Calendar date, String format) {
            return CalendarFormatter.format(format, date);
        }
    }

    static abstract class AbstractDesignerDateType
    extends DesignerType {
        static final String SIMPLE_DATE_FORMAT = "yyyyMMdd";
        static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";
        static final String SIMPLE_DATE_TIME_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";

        protected AbstractDesignerDateType(String name, Class valueClass, Class valueObjectClass) {
            super(name, valueClass, valueObjectClass, "DateList");
        }

        public final Object parse(String str) throws TransformException {
            try {
                return this.parse0(str);
            }
            catch (TransformRuntimeException e) {
                this.throwConversionException(str);
                return null;
            }
            catch (IllegalArgumentException e) {
                this.throwConversionException(str);
                return null;
            }
        }

        protected abstract Object parse0(String var1) throws TransformException;

        public Object parse(String str, String pattern) throws TransformException {
            if (pattern == null) {
                return this.parse(str);
            }
            try {
                if (Parsing.isISOPattern(pattern)) {
                    return CalendarParser.parse(pattern, str).getTime();
                }
                return Parsing.parseDate(str, pattern);
            }
            catch (IllegalArgumentException e) {
                this.throwConversionException(str, pattern);
                return null;
            }
            catch (TransformRuntimeException e) {
                this.throwConversionException(str, pattern);
                return null;
            }
        }

        public String format(Object obj, String pattern) {
            if (pattern == null) {
                return this.format(obj);
            }
            Date date = (Date)obj;
            if (Parsing.isISOPattern(pattern)) {
                return CalendarFormatter.format(pattern, date);
            }
            return Parsing.formatDate(date, pattern);
        }

        public boolean isValidFormat(DesignerType type, String parsingFormat) throws IllegalArgumentException {
            String designerDataFormat = AbstractDesignerDateType.getDesignerDateFormat(parsingFormat);
            return true;
        }

        public boolean isValidValue(String value, String format) {
            try {
                String designerDataFormat = AbstractDesignerDateType.getDesignerDateFormat(format);
                try {
                    AbstractDesignerDateType.parseDate(value, designerDataFormat);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                catch (TransformRuntimeException e) {
                    return false;
                }
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public static Date parseDate(String arg, String pattern) throws ParseException {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern(pattern);
            df.setLenient(false);
            Date date = df.parse(arg);
            return date;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return srcType instanceof AbstractDesignerDateType;
        }

        public static String formatDate(Date date, String pattern) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern(pattern);
            String formattedString = df.format(date);
            return formattedString;
        }

        public static String getDesignerDateFormat(String format) {
            if (format.equals("YYYYMMDD")) {
                return SIMPLE_DATE_FORMAT;
            }
            if (format.equals("MM/DD/YYYY")) {
                return "MM/dd/yyyy";
            }
            if (format.equals("DD/MM/YYYY")) {
                return "dd/MM/yyyy";
            }
            return format;
        }

        public static String[] getDesignerDateFormats() {
            return new String[]{SIMPLE_DATE_FORMAT, "MM/dd/yyyy", "dd/MM/yyyy", SIMPLE_TIME_FORMAT, "HH:mm:ss.SSS", "HH:mm", "yyyyMMdd-HH:mm:ss", SIMPLE_DATE_TIME_FORMAT};
        }
    }
}

