/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.Query;
import com.tplus.transform.runtime.persistence.expression.Expression;
import com.tplus.transform.runtime.persistence.expression.Order;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DynamicQuery
extends Query {
    public static final String DYNAMIC = "Dynamic";
    private List expressions = new ArrayList();
    private List orderings = new ArrayList();

    public DynamicQuery() {
        super(DYNAMIC);
    }

    public DynamicQuery add(Expression expression) {
        if (expression != null) {
            this.expressions.add(expression);
        }
        return this;
    }

    public Iterator iterateExpressions() {
        return this.expressions.iterator();
    }

    public Iterator iterateOrderings() {
        return this.orderings.iterator();
    }

    public String toString() {
        return this.expressions.toString();
    }

    public DynamicQuery addOrder(Order ordering) {
        this.orderings.add(ordering);
        return this;
    }

    public Object[] getParameterValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator iter = this.iterateExpressions();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            Object[] tv = expr.getValues();
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i]);
            }
        }
        return values.toArray();
    }

    public String getCondition() {
        FastStringBuffer condition = new FastStringBuffer(30);
        Iterator iter = this.iterateExpressions();
        if (!iter.hasNext()) {
            condition.append("1=1");
        }
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            condition.append(expr.toSqlString());
            if (!iter.hasNext()) continue;
            condition.append(" and ");
        }
        FastStringBuffer orderBy = new FastStringBuffer(30);
        iter = this.iterateOrderings();
        while (iter.hasNext()) {
            Order ord = (Order)iter.next();
            orderBy.append(ord.toSqlString());
            if (!iter.hasNext()) continue;
            orderBy.append(", ");
        }
        FastStringBuffer toRet = new FastStringBuffer();
        toRet.append(condition);
        if (orderBy.length() > 0) {
            toRet.append(" order by ");
            toRet.append(orderBy);
        }
        return toRet.toString();
    }
}

