/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.AbstractDataObject;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.MapObject;
import com.tplus.transform.runtime.TransformExceptionHelper;
import com.tplus.transform.runtime.TransformNestableException;
import com.tplus.transform.util.SequencedHashMap;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class ExceptionDataObject
extends AbstractDataObject
implements ExceptionObject,
TransformNestableException,
MapObject {
    protected static DataObjectMetaInfoImpl metaInfo;
    private String _Type;
    private String _Message;
    private String _ErrorCode;
    private String _Severity;
    private boolean _Cascadable;
    private String _FieldName;
    private String _FieldID;
    public static final String THIS_EXCEPTION_TYPE = "TransformException";
    DataObject source;
    private Map exceptionContext;

    public ExceptionDataObject() {
        this.setType(THIS_EXCEPTION_TYPE);
        this.setSeverity("fatal");
        this.setCascadable(true);
        this.setMessage("No message");
    }

    public ExceptionDataObject(String message) {
        this.setType(THIS_EXCEPTION_TYPE);
        this.setSeverity("fatal");
        this.setCascadable(true);
        this.setMessage(message);
    }

    public void reset() {
        super.reset();
    }

    public final String getType() {
        super.ensureNotNull(0);
        return this._Type;
    }

    public final void setType(String value) {
        super.setNull(0, value == null);
        this._Type = value;
    }

    public final String getMessage() {
        super.ensureNotNull(1);
        return this._Message;
    }

    public final void setMessage(String value) {
        if (value == null) {
            value = "";
        }
        super.setNull(1, value == null);
        this._Message = value;
    }

    public final String getErrorCode() {
        super.ensureNotNull(2);
        return this._ErrorCode;
    }

    public final void setErrorCode(String value) {
        super.setNull(2, value == null);
        this._ErrorCode = value;
    }

    public TransformNestableException getNextException() {
        return null;
    }

    public final String getSeverity() {
        super.ensureNotNull(3);
        return this._Severity;
    }

    public final void setSeverity(String value) {
        super.setNull(3, value == null);
        this._Severity = value;
    }

    public final boolean getCascadable() {
        super.ensureNotNull(4);
        return this._Cascadable;
    }

    public final void setCascadable(boolean value) {
        super.setNotNull(4);
        this._Cascadable = value;
    }

    public final String getFieldName() {
        return this._FieldName;
    }

    public final void setFieldName(String value) {
        super.setNull(5, value == null);
        this._FieldName = value;
    }

    public final String getFieldID() {
        return this._FieldID;
    }

    public final void setFieldID(String value) {
        super.setNull(6, value == null);
        this._FieldID = value;
    }

    protected Object getField0(int index) throws FieldNotFoundException {
        switch (index) {
            case 0: {
                return this._Type;
            }
            case 1: {
                return this._Message;
            }
            case 2: {
                return this._ErrorCode;
            }
            case 3: {
                return this._Severity;
            }
            case 4: {
                return Wrapper.box(this._Cascadable);
            }
            case 5: {
                return this._FieldName;
            }
            case 6: {
                return this._FieldID;
            }
        }
        return super.getField0(index);
    }

    protected void setField0(int index, Object value) throws FieldNotFoundException {
        switch (index) {
            case 0: {
                this._Type = (String)value;
                break;
            }
            case 1: {
                this._Message = (String)value;
                break;
            }
            case 2: {
                this._ErrorCode = (String)value;
                break;
            }
            case 3: {
                this._Severity = (String)value;
                break;
            }
            case 4: {
                this._Cascadable = (Boolean)value;
                break;
            }
            case 5: {
                this._FieldName = (String)value;
                break;
            }
            case 6: {
                this._FieldID = (String)value;
                break;
            }
            default: {
                super.setField0(index, value);
            }
        }
    }

    public DataObjectMetaInfo getMetaInfo() {
        return metaInfo;
    }

    public String toXMLString() {
        return TransformExceptionHelper.toXMLString(this, false);
    }

    public static DataObjectMetaInfoImpl getMetaInfoForClass() {
        if (metaInfo == null) {
            metaInfo = new DataObjectMetaInfoImpl(THIS_EXCEPTION_TYPE);
        }
        return metaInfo;
    }

    public final void setFieldValue(String value) {
        this.setContextProperty("Field-Value", value);
    }

    public final String getFieldValue() {
        return (String)this.getContextProperty("Field-Value");
    }

    public DataObject getSource() {
        return this.source;
    }

    public void setSource(DataObject source) {
        this.source = source;
    }

    public void setErrorPhase(String phase) {
        this.setContextProperty("Error-Phase", phase);
    }

    public String getErrorPhase() {
        return (String)this.getContextProperty("Error-Phase");
    }

    public void setErrorType(String errorType) {
        this.setContextProperty("Error-Type", errorType);
    }

    public String getErrorType() {
        return (String)this.getContextProperty("Error-Type");
    }

    public String getRootXMLTag() {
        return this.getType();
    }

    public boolean instanceOf(String exceptionType) {
        return exceptionType.equals(THIS_EXCEPTION_TYPE);
    }

    public Map getExceptionContext() {
        if (this.exceptionContext == null) {
            this.exceptionContext = new SequencedHashMap();
        }
        return this.exceptionContext;
    }

    public void setContextProperty(String name, Object value) {
        if (value == null) {
            this.getExceptionContext().remove(name);
        } else {
            this.getExceptionContext().put(name, value);
        }
    }

    public Object getContextProperty(String name) {
        return this.getExceptionContext().get(name);
    }

    public void printStackTrace(PrintStream s) {
    }

    public void printStackTrace(PrintWriter s) {
    }

    public void addTrace(String entityType, String entity, String subEntity) {
        String trace = (String)this.getContextProperty("Trace");
        String toAdd = "at " + entity;
        if (subEntity != null) {
            toAdd = toAdd + "." + subEntity;
        }
        trace = trace == null ? toAdd : trace + "\n    " + toAdd;
        this.setContextProperty("Trace", trace);
    }

    public String getContextMessage() {
        if (this.exceptionContext == null) {
            return "";
        }
        return this.exceptionContext.toString();
    }

    public Object clone() {
        ExceptionDataObject cloned = (ExceptionDataObject)super.clone();
        if (this.exceptionContext != null) {
            cloned.exceptionContext = new SequencedHashMap(this.exceptionContext);
        }
        return cloned;
    }

    public void setErrorField(DataObject obj, int index, Object value) {
        try {
            this.setFieldID(obj.getFieldID(index));
            this.setFieldName(obj.getQualifiedName(index));
            if (value instanceof String) {
                this.setFieldValue((String)value);
            }
        }
        catch (FieldNotFoundException e) {
            // empty catch block
        }
    }

    public void setErrorSection(DataObjectSection sectionField, Object value) {
        try {
            DataObject obj;
            if (sectionField != null && (obj = sectionField.getParent()) != null) {
                int index = obj.getFieldIndex(sectionField.getName());
                this.setFieldID(obj.getFieldID(index));
                this.setFieldName(obj.getQualifiedName(index));
                if (value instanceof String) {
                    this.setFieldValue((String)value);
                }
            }
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    public void setErrorObject(DataObject obj, Object value) {
        try {
            DataObjectSection parentSection = obj.getParentSection();
            this.setErrorSection(parentSection, value);
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            // empty catch block
        }
    }

    public Iterator getOtherFields() {
        return this.getExceptionContext().keySet().iterator();
    }

    public Object getFieldValue(String fieldName) {
        return this.getExceptionContext().get(fieldName);
    }

    static {
        ExceptionDataObject.getMetaInfoForClass().initFields(new FieldMetaInfo[]{new FieldMetaInfoImpl("Type", DesignerTypes.STRING_TYPE, false), new FieldMetaInfoImpl("Message", DesignerTypes.STRING_TYPE, false), new FieldMetaInfoImpl("ErrorCode", DesignerTypes.STRING_TYPE, true), new FieldMetaInfoImpl("Severity", DesignerTypes.STRING_TYPE, false), new FieldMetaInfoImpl("Cascadable", DesignerTypes.BOOLEAN_TYPE, false), new FieldMetaInfoImpl("FieldName", DesignerTypes.STRING_TYPE, true), new FieldMetaInfoImpl("FieldID", DesignerTypes.STRING_TYPE, true)});
    }
}

