/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.log.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface ExceptionHandler
extends Serializable {
    public static final Log log = LogFactory.getRuntimeLog();
    public static final ExceptionHandler DRACONIAN_EXCEPTION_HANDLER = new DraconianExceptionHandler();

    public void onException(ExceptionObject var1) throws TransformException;

    public static class CascadingExceptionHandler
    implements ExceptionHandler {
        List exceptions = Collections.EMPTY_LIST;

        public void onException(ExceptionObject e) throws TransformException {
            if (!(this.exceptions instanceof ArrayList)) {
                this.exceptions = new ArrayList();
            }
            if (e instanceof TransformException) {
                TransformException tx = (TransformException)e;
                DataObjectSection exceptionObjects = tx.getExceptions();
                if (exceptionObjects.size() == 1) {
                    this.exceptions.add(tx);
                } else {
                    for (int i = 0; i < exceptionObjects.getElementCount(); ++i) {
                        this.exceptions.add(exceptionObjects.getElement(i));
                    }
                }
            } else {
                if (e == null) {
                    log.unexpectedError(new Exception("Unexpected null exception"));
                }
                this.exceptions.add(e);
            }
        }

        public List getExceptions() {
            return this.exceptions;
        }

        public boolean hasExceptions() {
            return this.exceptions.size() > 0;
        }
    }

    public static class DraconianExceptionHandler
    implements ExceptionHandler,
    Serializable {
        public void onException(ExceptionObject e) throws TransformException {
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            throw new TransformException(e);
        }
    }
}

