/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.MappingInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;

public class ExceptionMappingHelper {
    public static TransformException map(TransformException e, MappingInfo mappingInfo) {
        DataObjectSection exceptionObjects = (DataObjectSection)e.getExceptions().clone();
        TransformException toRet = new TransformException(exceptionObjects);
        for (int i = 0; i < exceptionObjects.getElementCount(); ++i) {
            ExceptionObject exceptionObject = (ExceptionObject)exceptionObjects.getElement(i);
            exceptionObject.setFieldID(mappingInfo.srcIDToDest(exceptionObject.getFieldID()));
            exceptionObject.setFieldName(mappingInfo.srcNameToDest(exceptionObject.getFieldName()));
        }
        return toRet;
    }

    public static TransformException reverseMap(TransformException e, MappingInfo mappingInfo) {
        DataObjectSection sourceExceptionObjects = e.getExceptions();
        if (sourceExceptionObjects == null) {
            throw TransformRuntimeException.createFormatted("SRT652");
        }
        DataObjectSection exceptionObjects = (DataObjectSection)sourceExceptionObjects.clone();
        TransformException toRet = new TransformException(exceptionObjects);
        for (int i = 0; i < exceptionObjects.getElementCount(); ++i) {
            ExceptionObject exceptionObject = (ExceptionObject)exceptionObjects.getElement(i);
            exceptionObject.setFieldID(mappingInfo.destIDToSrc(exceptionObject.getFieldID()));
            exceptionObject.setFieldName(mappingInfo.destNameToSrc(exceptionObject.getFieldName()));
        }
        return toRet;
    }
}

