/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractDataObject;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.xml.DataObjectXMLWriter;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.QName;
import java.io.Serializable;

public class ExternalObjectImpl
extends AbstractDataObject
implements ExternalObject,
Serializable {
    static DataObjectMetaInfoImpl externalMetaInfo = new DataObjectMetaInfoImpl("ExternalObject", new FieldMetaInfo[]{new SectionMetaInfoImpl(null, DesignerTypes.DATAOBJECT_TYPE, "Header", 1, 1, false), new SectionMetaInfoImpl(null, DesignerTypes.DATAOBJECT_TYPE, "Data", 1, 1, false), new SectionMetaInfoImpl(null, DesignerTypes.DATAOBJECT_TYPE, "Trailer", 1, 1, false)});
    DataObject header;
    DataObject data;
    DataObject trailer;
    String messageName;
    transient DataObjectMetaInfo metaInfo;
    private QName QNameShared;

    public ExternalObjectImpl() {
    }

    public ExternalObjectImpl(String messageName, DataObject header, DataObject data, DataObject trailer) {
        this.messageName = StringUtils.isEmpty(messageName) ? null : messageName;
        this.header = header;
        this.data = data;
        this.trailer = trailer;
        this.setNotNull(0);
        this.setNotNull(1);
        this.setNotNull(2);
        this.getMetaInfo();
    }

    public void reset() {
        if (this.header != null) {
            this.header.reset();
        }
        if (this.data != null) {
            this.data.reset();
        }
        if (this.trailer != null) {
            this.trailer.reset();
        }
    }

    public DataObject getHeader() {
        return this.header;
    }

    public DataObject getData() {
        return this.data;
    }

    public DataObject getTrailer() {
        return this.trailer;
    }

    protected Object getField0(int index) throws FieldNotFoundException {
        switch (index) {
            case 0: {
                return this.header;
            }
            case 1: {
                return this.data;
            }
            case 2: {
                return this.trailer;
            }
        }
        return super.getField0(index);
    }

    protected void setField0(int index, Object value) throws FieldNotFoundException {
        switch (index) {
            case 0: {
                this.header = (DataObject)value;
                break;
            }
            case 1: {
                this.data = (DataObject)value;
                break;
            }
            case 2: {
                this.trailer = (DataObject)value;
                break;
            }
            default: {
                super.setField0(index, value);
            }
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public DataObjectMetaInfo getMetaInfo() {
        if (this.metaInfo == null || this.metaInfo == externalMetaInfo) {
            if (this.data != null) {
                this.getComputedMetaInfo();
                if (this.metaInfo == null) {
                    String name;
                    String string = name = this.messageName == null ? "ExternalObject" : this.messageName;
                    if (this.messageName == null) {
                        // empty if block
                    }
                    this.metaInfo = new DataObjectMetaInfoImpl(name, new FieldMetaInfo[]{this.createHeaderMetaInfo(), this.createDataMetaInfo(), this.createTrailerMetaInfo()});
                }
            } else {
                this.metaInfo = externalMetaInfo;
            }
        }
        return this.metaInfo;
    }

    private SectionMetaInfo createDataMetaInfo() {
        DataObjectMetaInfo info = this.data == null ? null : this.data.getMetaInfo();
        SectionMetaInfoImpl sectionInfo = new SectionMetaInfoImpl(info, DesignerTypes.DATAOBJECT_TYPE, "Data", 1, 1, false);
        sectionInfo.setXMLQName(this.data.getXMLQName());
        return sectionInfo;
    }

    private SectionMetaInfo createTrailerMetaInfo() {
        DataObjectMetaInfo info = this.trailer == null ? null : this.trailer.getMetaInfo();
        SectionMetaInfoImpl sectionInfo = new SectionMetaInfoImpl(info, DesignerTypes.DATAOBJECT_TYPE, "Trailer", 1, 1, false);
        if (this.trailer != null) {
            sectionInfo.setXMLQName(this.trailer.getXMLQName());
        }
        return sectionInfo;
    }

    private SectionMetaInfo createHeaderMetaInfo() {
        DataObjectMetaInfo info = this.header == null ? null : this.header.getMetaInfo();
        SectionMetaInfoImpl sectionInfo = new SectionMetaInfoImpl(info, DesignerTypes.DATAOBJECT_TYPE, "Header", 1, 1, false);
        if (this.header != null) {
            sectionInfo.setXMLQName(this.header.getXMLQName());
        }
        return sectionInfo;
    }

    private void getComputedMetaInfo() {
        SectionMetaInfo sectionMetaInfo = this.data.getMetaInfo().getParentSection();
        this.metaInfo = sectionMetaInfo != null ? sectionMetaInfo.getParentMetaInfo() : null;
    }

    public String toXMLString() {
        DataObjectXMLWriter writer = new DataObjectXMLWriter();
        return (String)writer.toXMLString(this);
    }

    public Object clone() {
        ExternalObjectImpl clonedObject = (ExternalObjectImpl)super.clone();
        if (this.header != null) {
            clonedObject.header = (DataObject)this.header.clone();
        }
        clonedObject.data = (DataObject)this.data.clone();
        if (this.trailer != null) {
            clonedObject.trailer = (DataObject)this.trailer.clone();
        }
        return clonedObject;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public ExternalObjectImpl setXMLQName(QName qName) {
        DataObjectMetaInfoImpl dataObjectMetaInfo = (DataObjectMetaInfoImpl)this.getMetaInfo();
        dataObjectMetaInfo.setXMLQName(qName);
        return this;
    }

    public ExternalObjectImpl setXMLQName(String xmlName, String xmlNamespace) {
        DataObjectMetaInfoImpl dataObjectMetaInfo = (DataObjectMetaInfoImpl)this.getMetaInfo();
        dataObjectMetaInfo.setXMLQName(new QName(xmlNamespace, xmlName));
        return this;
    }

    public ExternalObjectImpl setQNameShared(QName qName) {
        this.QNameShared = qName;
        return this;
    }

    public ExternalObjectImpl setQNameShared(String xmlName, String xmlNamespace) {
        this.QNameShared = new QName(xmlNamespace, xmlName);
        return this;
    }

    public QName getQNameShared() {
        if (this.QNameShared == null) {
            return this.getXMLQName();
        }
        return this.QNameShared;
    }
}

