/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import java.util.ArrayList;
import java.util.List;

public class FieldId {
    private List nodes;

    public FieldId(String fieldId) {
        this.nodes = fieldId == null ? new ArrayList() : this.parseFieldId(fieldId);
    }

    public FieldId(List nodes) {
        this.nodes = nodes;
    }

    public int length() {
        return this.nodes.size();
    }

    public boolean equals(Object other) {
        if (other instanceof FieldId) {
            FieldId otherFieldId = (FieldId)other;
            if (this.nodes.size() == otherFieldId.nodes.size()) {
                for (int i = 0; i < this.nodes.size(); ++i) {
                    FieldNodeInfo otherFieldNodeInfo;
                    FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(i);
                    if (fieldNodeInfo.equals(otherFieldNodeInfo = (FieldNodeInfo)otherFieldId.nodes.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isAncestorOf(FieldId id) {
        for (FieldId parent = id.getParentFieldId(); parent != null; parent = parent.getParentFieldId()) {
            if (!this.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getFieldId(true);
    }

    public String getQualifiedFieldName() {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(i);
            Object name = fieldNodeInfo.getName();
            if (toRet.length() > 0) {
                toRet.append('.');
            }
            toRet.append(name);
        }
        return toRet.toString();
    }

    public String getFieldId() {
        return this.getFieldId(true);
    }

    public String getFieldId(boolean normalized) {
        return this.getFieldId(normalized, '.');
    }

    public String getFieldId(boolean normalized, char separator) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(i);
            Object name = fieldNodeInfo.getName();
            if (toRet.length() > 0) {
                toRet.append(separator);
            }
            toRet.append(name);
            if (i >= this.nodes.size() - 1 && normalized) continue;
            toRet.append('[');
            toRet.append(fieldNodeInfo.getIndexValue());
            toRet.append(']');
        }
        return toRet.toString();
    }

    public String getFullPath(char separator) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(i);
            Object name = fieldNodeInfo.getName();
            if (toRet.length() > 0) {
                toRet.append(separator);
            }
            toRet.append(name);
            if (i >= this.nodes.size() - 1 || !fieldNodeInfo.isIndexSpecified()) continue;
            toRet.append('[');
            toRet.append(fieldNodeInfo.getIndexValue());
            toRet.append(']');
        }
        return toRet.toString();
    }

    public String getFieldNameAt(int index) {
        if (this.nodes.size() > index) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(index);
            return fieldNodeInfo.getName().toString();
        }
        return "";
    }

    public Object getFieldComponentAt(int index) {
        if (this.nodes.size() > index) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(index);
            return fieldNodeInfo.getName();
        }
        return "";
    }

    public int getFieldIndexAt(int index) {
        if (this.nodes.size() > index) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(index);
            return fieldNodeInfo.getIndexValue();
        }
        return -1;
    }

    public boolean isIndexSpecifiedAt(int index) {
        if (this.nodes.size() > index) {
            FieldNodeInfo fieldNodeInfo = (FieldNodeInfo)this.nodes.get(index);
            return fieldNodeInfo.isIndexSpecified();
        }
        return false;
    }

    public int getFieldLevels() {
        return this.nodes.size();
    }

    public FieldId getParentFieldId() {
        if (this.nodes.size() > 1) {
            return new FieldId(this.nodes.subList(0, this.nodes.size() - 1));
        }
        return null;
    }

    public FieldId getSubFieldId(int uptoIndex) {
        return new FieldId(this.nodes.subList(0, uptoIndex));
    }

    private List parseFieldId(String fieldId) {
        ArrayList<FieldNodeInfo> fieldNodes = new ArrayList<FieldNodeInfo>();
        boolean inIndex = false;
        StringBuffer indexStr = new StringBuffer();
        StringBuffer fieldName = new StringBuffer();
        int indexValue = 0;
        boolean indexSpecified = false;
        for (int i = 0; i < fieldId.length(); ++i) {
            char c = fieldId.charAt(i);
            if (inIndex) {
                if (c == ']') {
                    indexValue = this.parseInt(indexStr.toString());
                    indexSpecified = true;
                    inIndex = false;
                    continue;
                }
                indexStr.append(c);
                continue;
            }
            if (c == '[') {
                inIndex = true;
                continue;
            }
            if (c == '.') {
                fieldNodes.add(new FieldNodeInfo(fieldName.toString(), indexValue, indexSpecified));
                indexValue = 0;
                indexSpecified = false;
                fieldName.setLength(0);
                indexStr.setLength(0);
                continue;
            }
            fieldName.append(c);
        }
        fieldNodes.add(new FieldNodeInfo(fieldName.toString(), indexValue, indexSpecified));
        return fieldNodes;
    }

    private int parseInt(String indexStr) {
        try {
            int indexValue = Integer.parseInt(indexStr);
            return indexValue;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    public int getLastIndexValue() {
        FieldNodeInfo node = (FieldNodeInfo)this.nodes.get(this.nodes.size() - 1);
        return node.getIndexValue();
    }

    public void setLastIndexValue(int index) {
        FieldNodeInfo node = (FieldNodeInfo)this.nodes.get(this.nodes.size() - 1);
        node.setIndexValue(index);
    }

    public FieldId getFieldIdForQName(String qName) {
        FieldId subFieldId;
        int count = this.getFieldPartCount(qName);
        if (this.nodes.size() >= count && (subFieldId = this.getSubFieldId(count)).getQualifiedFieldName().equals(qName)) {
            return subFieldId;
        }
        return null;
    }

    private int getFieldPartCount(String qName) {
        int start = 0;
        int count = 0;
        while ((start = qName.indexOf(46, start)) != -1) {
            ++count;
            ++start;
        }
        return count + 1;
    }

    public static class FieldNodeInfo {
        private Object name;
        private int indexValue;
        boolean indexSpecified;

        public FieldNodeInfo(String name, int indexValue) {
            this(name, indexValue, true);
        }

        public FieldNodeInfo(String name, int indexValue, boolean indexSpecified) {
            this.name = name;
            this.indexValue = indexValue;
            this.indexSpecified = indexSpecified;
        }

        public boolean isIndexSpecified() {
            return this.indexSpecified;
        }

        public int getIndexValue() {
            return this.indexValue;
        }

        public void setIndexValue(int index) {
            this.indexValue = index;
        }

        public Object getName() {
            return this.name;
        }

        public boolean equals(Object other) {
            if (other instanceof FieldNodeInfo) {
                FieldNodeInfo otherInfo = (FieldNodeInfo)other;
                if (this.name.equals(otherInfo.name) && this.indexValue == otherInfo.indexValue) {
                    return true;
                }
            }
            return false;
        }
    }
}

