/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.FieldId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FieldMapper
implements Serializable {
    Map map = new HashMap();

    FieldMapper() {
    }

    private List mapID0(String destFieldIDStr) {
        FieldId destFieldID = new FieldId(destFieldIDStr);
        String destFieldName = destFieldID.getQualifiedFieldName();
        ArrayList<String> srcFieldNames = new ArrayList<String>(this.getMappings0(destFieldName));
        for (int i = 0; i < srcFieldNames.size(); ++i) {
            String srcName = (String)srcFieldNames.get(i);
            FieldId srcFieldId = new FieldId(srcName);
            this.introduceFieldID(srcFieldId, destFieldID);
            srcFieldNames.set(i, srcFieldId.getFieldId(false));
        }
        return srcFieldNames;
    }

    private List getMappings0(String field) {
        List toRet = (List)this.map.get(field);
        if (toRet == null) {
            toRet = Collections.EMPTY_LIST;
        }
        return toRet;
    }

    private void introduceFieldID(FieldId srcFieldId, FieldId destFieldID) {
        FieldId srcParentSecId = srcFieldId.getParentFieldId();
        for (FieldId destParentSecId = destFieldID.getParentFieldId(); destParentSecId != null && srcParentSecId != null; destParentSecId = destParentSecId.getParentFieldId()) {
            List srcMappings = this.getMappings0(destParentSecId.getQualifiedFieldName());
            if (srcMappings.size() <= 0) continue;
            String srcMapping = (String)srcMappings.get(0);
            int index = destParentSecId.getLastIndexValue();
            FieldId matchedSrcFieldId = srcParentSecId.getFieldIdForQName(srcMapping);
            if (matchedSrcFieldId == null) continue;
            matchedSrcFieldId.setLastIndexValue(index);
            srcParentSecId = matchedSrcFieldId;
        }
    }

    public void addToMap(String destField, String srcField) {
        ArrayList<String> existing = (ArrayList<String>)this.map.get(destField);
        if (existing == null) {
            this.map.put(destField, Collections.singletonList(srcField));
        } else {
            if (!(existing instanceof ArrayList)) {
                existing = new ArrayList<String>(existing);
                this.map.put(destField, existing);
            }
            existing.add(srcField);
        }
    }

    public List mapID(String srcFieldID) {
        if (srcFieldID == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mapID0(srcFieldID);
    }

    public List mapField(String srcField) {
        if (srcField == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getMappings0(srcField);
    }

    public String mapFieldSingle(String srcField) {
        List toRet = this.mapField(srcField);
        if (toRet.size() > 0) {
            return this.getFirstFieldName(toRet);
        }
        FieldId parentId = new FieldId(srcField).getParentFieldId();
        if (parentId != null) {
            return this.mapFieldSingle(parentId.getQualifiedFieldName());
        }
        return null;
    }

    public String mapIDSingle(String srcFieldID) {
        List toRet = this.mapID(srcFieldID);
        if (toRet.size() > 0) {
            return this.getFirstFieldId(toRet);
        }
        FieldId parentId = new FieldId(srcFieldID).getParentFieldId();
        if (parentId != null) {
            return this.mapIDSingle(parentId.getFieldId());
        }
        return null;
    }

    private String getFirstFieldId(List toRet) {
        if (toRet != null && toRet.size() > 0) {
            if (toRet.size() == 1) {
                return new FieldId((String)toRet.get(0)).toString();
            }
            FieldId bestFieldID = null;
            for (int i = 0; i < toRet.size(); ++i) {
                FieldId id = new FieldId((String)toRet.get(i));
                if (bestFieldID == null) {
                    bestFieldID = id;
                    continue;
                }
                if (!bestFieldID.isAncestorOf(id)) continue;
                bestFieldID = id;
            }
            return bestFieldID.toString();
        }
        return null;
    }

    private String getFirstFieldName(List toRet) {
        if (toRet != null && toRet.size() > 0) {
            if (toRet.size() == 1) {
                return new FieldId((String)toRet.get(0)).getQualifiedFieldName();
            }
            FieldId bestFieldID = null;
            for (int i = 0; i < toRet.size(); ++i) {
                FieldId id = new FieldId((String)toRet.get(i));
                if (bestFieldID == null) {
                    bestFieldID = id;
                    continue;
                }
                if (!bestFieldID.isAncestorOf(id)) continue;
                bestFieldID = id;
            }
            return bestFieldID.getQualifiedFieldName();
        }
        return null;
    }
}

