/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.PropertyMapImpl;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLUtils;
import java.io.Serializable;

public class FieldMetaInfoImpl
implements FieldMetaInfo,
Cloneable,
Serializable {
    private String fieldName;
    private DesignerType designerType;
    private boolean optional;
    private boolean synthesized;
    private int index;
    private String mangledName;
    PropertyMap properties;
    DataObjectMetaInfo parentMetaInfo;
    private QName qName;
    private XMLFieldType xmlFieldType = XMLFieldType.ELEMENT;
    static final long serialVersionUID = 223L;

    public FieldMetaInfoImpl(String fieldName, String type, boolean optional) {
        this(fieldName, type, optional, false);
    }

    public FieldMetaInfoImpl(String fieldName, String type, boolean optional, boolean synthesized) {
        this(fieldName, DesignerType.valueOf(type), optional, synthesized);
    }

    public FieldMetaInfoImpl(String fieldName, DesignerType designerType, boolean optional) {
        this(fieldName, designerType, optional, false);
    }

    public FieldMetaInfoImpl(String fieldName, DesignerType designerType) {
        this(fieldName, designerType, true, false);
    }

    public FieldMetaInfoImpl(String fieldName) {
        this(fieldName, DesignerType.DESIGNER_STRING_TYPE, true, false);
    }

    public FieldMetaInfoImpl(String fieldName, DesignerType designerType, boolean optional, boolean synthesized) {
        this.fieldName = fieldName;
        this.designerType = designerType;
        this.index = -1;
        this.optional = optional;
        this.synthesized = synthesized;
    }

    public FieldMetaInfoImpl setXMLQName(String xmlName, String xmlNamespace) {
        this.qName = new QName(xmlNamespace, xmlName);
        return this;
    }

    public FieldMetaInfoImpl setFieldXMLType(XMLFieldType xmlFieldType) {
        this.xmlFieldType = xmlFieldType;
        return this;
    }

    public QName getXMLQName() {
        if (this.qName == null) {
            this.qName = new QName(null, this.getMangledName());
        }
        return this.qName;
    }

    public FieldMetaInfoImpl setNamespace(String namespace) {
        this.qName = this.qName != null ? new QName(namespace, this.qName.getLocalPart()) : new QName(namespace, this.getMangledName());
        return this;
    }

    public void setXMLQName(QName qName) {
        this.qName = qName;
    }

    public final String getName() {
        return this.fieldName;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        if (index == -1) {
            throw TransformRuntimeException.createFormatted("SRT455", this.fieldName);
        }
        this.index = index;
    }

    public final String getType() {
        return this.designerType.getName();
    }

    public final DesignerType getDesignerType() {
        return this.designerType;
    }

    public final boolean isOptional() {
        return this.optional;
    }

    protected void setOptional(boolean bl) {
        this.optional = bl;
    }

    public int getMinOccurs() {
        return this.optional ? 0 : 1;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public boolean isRepeating() {
        return false;
    }

    public boolean isSection() {
        return false;
    }

    public final boolean isSynthesized() {
        return this.synthesized;
    }

    public final String getMangledName() {
        if (this.mangledName == null) {
            this.mangledName = FieldMetaInfoImpl.computeMangledName(this.fieldName);
        }
        return this.mangledName;
    }

    public static String computeMangledName(String fldName) {
        return XMLUtils.computeXMLName(fldName);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Unexpected clone error");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldMetaInfo)) {
            return false;
        }
        FieldMetaInfoImpl fieldMetaInfo = (FieldMetaInfoImpl)o;
        if (this.index != fieldMetaInfo.index) {
            return false;
        }
        if (!this.designerType.equals(fieldMetaInfo.designerType)) {
            return false;
        }
        return this.fieldName.equals(fieldMetaInfo.fieldName);
    }

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public String toString() {
        return this.fieldName;
    }

    public Object getProperty(String name) {
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    public XMLFieldType getFieldXMLType() {
        return this.xmlFieldType;
    }

    public QName getQNameShared() {
        return this.getXMLQName();
    }

    public XMLFieldType getXMLTypeShared() {
        return this.getFieldXMLType();
    }

    public String getStringProperty(String name) {
        if (this.properties != null) {
            return this.properties.getStringProperty(name, null);
        }
        return null;
    }

    public FieldMetaInfo setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new PropertyMapImpl();
        }
        this.properties.setProperty(name, value);
        return this;
    }

    public DataObjectMetaInfo getParentMetaInfo() {
        return this.parentMetaInfo;
    }

    public void setParentMetaInfo(DataObjectMetaInfo parentMetaInfo) {
        this.parentMetaInfo = parentMetaInfo;
    }

    public String getQualifiedName() {
        SectionMetaInfo sectionMetaInfo;
        DataObjectMetaInfo parentMetaInfo = this.getParentMetaInfo();
        if (parentMetaInfo != null && (sectionMetaInfo = parentMetaInfo.getParentSection()) != null) {
            return sectionMetaInfo.getQualifiedName() + "." + this.getName();
        }
        return this.getName();
    }
}

