/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.io.RandomAccessFileStream;
import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.runtime.FileInputSource;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class FileInputOutputMessage
extends FileInputSource
implements OutputDevice {
    private static final long serialVersionUID = 1L;

    public FileInputOutputMessage(String fileName) throws IOException {
        super(fileName);
    }

    protected RandomAccessFileStream createRandomAccessStream() throws FileNotFoundException {
        return new RandomAccessFileStream(this.fileName, "rw");
    }

    public void append(byte[] bytes) throws TransformException {
        this.checkAllowWrite();
        this.append(bytes, 0, bytes.length);
    }

    public void append(byte[] bytes, int start, int byteLength) throws TransformException {
        this.checkAllowWrite();
        try {
            this.initStream();
            this.seekTo(this.length);
            this.fileStream.write(bytes, start, byteLength);
            this.length += (long)byteLength;
            this.position += (long)byteLength;
        }
        catch (IOException e) {
            this.position = -1L;
            TransformException te = TransformException.createFormatted("SRT665");
            te.setDetail(e);
            throw te;
        }
    }

    public void append(String str) throws TransformException {
        this.checkAllowWrite();
        try {
            byte[] bytes = CharBinaryBuffer.stringToBytes(str, this.getEncoding());
            this.append(bytes);
        }
        catch (UnsupportedEncodingException e) {
            TransformException te = TransformException.createFormatted("SRT666");
            te.setDetail(e);
            throw te;
        }
    }

    public void append(RawMessage message) throws TransformException {
        this.checkAllowWrite();
        FileInputOutputMessage.appendRawMessage(this, message);
    }

    public static void appendRawMessage(RawMessage to, RawMessage message) throws TransformException {
        long length = message.getLength();
        if (length < 98304L) {
            to.append(message.getAsBytes());
        } else {
            long read;
            byte[] buffer = new byte[98304];
            int pos = 0;
            while ((read = (long)message.getBytes(pos, buffer, 0, 98304)) != 0L) {
                to.append(buffer, 0, (int)read);
                pos = (int)((long)pos + read);
            }
        }
    }

    public void appendold(RawMessage message) throws TransformException {
        this.checkAllowWrite();
        System.out.println("appendRawMessage");
        long length = message.getLength();
        if (length < 98304L) {
            this.append(message.getAsBytes());
        } else {
            System.out.println("appendRawMessage2 " + length);
            byte[] buffer = new byte[98304];
            int pos = 0;
            while ((long)pos < length) {
                long read = message.getBytes(pos, buffer, 0, 98304);
                this.append(buffer, 0, (int)read);
                pos = (int)((long)pos + read);
            }
        }
    }

    private void checkAllowWrite() {
    }
}

