/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.io.RandomAccessFileStream;
import com.tplus.transform.runtime.AbstractInputSource;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.StreamBaseInputSource;
import com.tplus.transform.runtime.TransformException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;

public class FileInputSource
extends StreamBaseInputSource {
    public static final String FILE_NAME = "file.name";
    public static final String FILE_PATH = "file.path";
    public static final int DEFAULT_BUFFER_LENGTH = 98304;
    protected String fileName;
    protected long length;
    transient RandomAccessFileStream fileStream;
    protected transient long position = -1L;
    transient Buffer buffer;
    private static final long serialVersionUID = 1L;

    public FileInputSource(String fileName) throws IOException {
        this(fileName, null);
    }

    public FileInputSource(String fileName, String encoding) throws IOException {
        this.fileName = fileName;
        File file = new File(fileName);
        this.length = file.length();
        super.setName(file.getName());
        this.setFileProperties(fileName);
        this.setEncoding(encoding);
    }

    public String getEncoding() {
        String enc = super.getEncoding();
        if (enc == null) {
            enc = AbstractRawMessage.PLATFORM_DEFAULT_ENCODING;
        }
        return enc;
    }

    public boolean isBinary() {
        return true;
    }

    public void setFileProperties(String fileName) {
        File file = new File(fileName);
        super.setName(file.getName());
        super.setProperty(FILE_NAME, file.getName());
        super.setProperty(FILE_PATH, fileName);
    }

    protected InputStream getAsStream0() throws IOException {
        return new FileInputStream(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getAsBytes0() throws IOException {
        InputStream asStream = this.getAsStream0();
        try {
            byte[] byArray = AbstractInputSource.readStream(asStream, (int)this.length);
            return byArray;
        }
        finally {
            asStream.close();
        }
    }

    public int getLength() {
        return (int)this.length;
    }

    public long getLongLength() {
        return this.length;
    }

    protected void initStream() throws IOException {
        if (this.fileStream == null) {
            this.fileStream = this.createRandomAccessStream();
            this.position = -1L;
        }
        if (this.position == -1L) {
            this.position = (int)this.fileStream.getPosition();
        }
    }

    protected RandomAccessFileStream createRandomAccessStream() throws FileNotFoundException {
        return new RandomAccessFileStream(this.fileName, "r");
    }

    public int getByte0(long at) throws TransformException {
        return this.getBuffer().getByte(at);
    }

    public int getBytes0(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        int read = this.getBuffer().getBytes(start_index, toRet, destLocation, num_chars);
        return read;
    }

    final Buffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new Buffer();
        }
        return this.buffer;
    }

    public void dispose() throws TransformException {
        this.closeStream();
        this.buffer = null;
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private int readBytes(long start_index, byte[] toRet, int destLocation, int num_chars) throws IOException {
        try {
            this.initStream();
            if (this.position <= this.length) {
                this.seekTo(start_index);
                int read = this.fileStream.read(toRet, destLocation, num_chars);
                if (read >= 0) {
                    this.position += (long)read;
                }
                return read;
            }
            return 0;
        }
        catch (IOException e) {
            this.position = -1L;
            throw e;
        }
    }

    protected void seekTo(long start_index) throws IOException {
        if (this.position > this.length) {
            throw StandardRuntimeResource.createEOFExceptionFormatted("SRT676", new Object[]{String.valueOf(start_index), String.valueOf(this.length)});
        }
        if (start_index != this.position) {
            this.fileStream.seek(start_index);
            this.position = start_index;
        }
    }

    protected void closeStream() {
        if (this.fileStream != null) {
            try {
                this.fileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileStream = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.closeStream();
        out.defaultWriteObject();
    }

    private void debugDump(String x) {
        System.out.println(x);
    }

    final class BufferData {
        byte[] bytes = new byte[49152];
        long start_pos;
        int dataLength;

        public final void swap(BufferData data) {
            byte[] b = this.bytes;
            long s = this.start_pos;
            int len = this.dataLength;
            this.bytes = data.bytes;
            this.start_pos = data.start_pos;
            this.dataLength = data.dataLength;
            data.bytes = b;
            data.start_pos = s;
            data.dataLength = len;
        }

        final boolean contains(long pos) {
            return this.start_pos <= pos && pos < this.start_pos + (long)this.dataLength;
        }

        public final int get(long at) {
            int location = (int)(at - this.start_pos);
            if (location >= this.dataLength || location < 0) {
                return -1;
            }
            return this.bytes[location] & 0xFF;
        }

        public String toString() {
            return "start = " + this.start_pos + ";dataLength = " + this.dataLength + ";totalLength = " + FileInputSource.this.length;
        }

        public void checkvariant() {
            if (this.start_pos < 0L || this.start_pos > FileInputSource.this.length || this.start_pos + (long)this.dataLength > FileInputSource.this.length || this.dataLength > this.bytes.length) {
                System.out.println("Invariant failed: " + this.toString());
            }
        }
    }

    final class Buffer {
        private BufferData previousData;
        BufferData data;

        public Buffer() {
            this.data = new BufferData();
            this.previousData = new BufferData();
        }

        void fill(long start_pos, String name) throws TransformException {
            try {
                this.previousData.swap(this.data);
                FileInputSource.this.initStream();
                if (start_pos < FileInputSource.this.length) {
                    FileInputSource.this.seekTo(start_pos);
                    this.data.dataLength = 0;
                    this.data.start_pos = start_pos;
                    int bytesRead = FileInputSource.this.readBytes(start_pos, this.data.bytes, 0, this.data.bytes.length);
                    if (bytesRead >= 0) {
                        this.data.dataLength = bytesRead;
                        this.data.checkvariant();
                    }
                }
            }
            catch (IOException e) {
                TransformException te = TransformException.createFormatted("SRT677");
                te.setDetail(e);
                throw te;
            }
        }

        final int getByte(long at) throws TransformException {
            if (!this.data.contains(at)) {
                this.makeAvailable(at, "getByte");
            }
            return this.data.get(at);
        }

        private void makeAvailable(long at, String name) throws TransformException {
            if (this.previousData.contains(at)) {
                this.previousData.swap(this.data);
            } else {
                this.fill(at, name);
            }
        }

        public final int getBytes(long at, byte[] toRet, int destLocation, int num_chars) throws TransformException {
            int toRead = num_chars;
            while (toRead > 0) {
                if (!this.data.contains(at)) {
                    this.makeAvailable(at, "getBytes");
                }
                if (this.data.dataLength == 0 || !this.data.contains(at)) break;
                int s = (int)(at - this.data.start_pos);
                int availLength = Math.min(this.data.dataLength - s, toRead);
                System.arraycopy(this.data.bytes, s, toRet, destLocation, availLength);
                toRead -= availLength;
                at += (long)availLength;
                destLocation += availLength;
            }
            return num_chars - toRead;
        }
    }
}

