/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.InputStreamRawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStreamRawMessage
extends InputStreamRawMessage {
    private String fileName;
    private long length;

    public FileInputStreamRawMessage(String fileName) throws TransformException {
        this(fileName, 0);
    }

    public FileInputStreamRawMessage(String fileName, int bufferSize) throws TransformException {
        super(true);
        this.setBufferSize(bufferSize);
        this.fileName = fileName;
        File file = new File(fileName);
        this.setFileProperties(fileName);
        this.length = file.length();
    }

    public void setFileProperties(String fileName) {
        File file = new File(fileName);
        super.setName(file.getName());
        super.setProperty("file.name", file.getName());
        super.setProperty("file.path", fileName);
    }

    public int getLength() {
        return (int)this.length;
    }

    public long getLongLength() {
        return this.length;
    }

    protected InputStream createStream() throws IOException {
        return new FileInputStream(this.fileName);
    }
}

