/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.IDisposable;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.util.log.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Stack;

public class Functions {
    private static TransformContext transformContext = new TransformContextImpl();
    static ThreadLocal functions = new ThreadLocal();

    public static TransformContext getTransformContext() {
        return transformContext;
    }

    public static Log getLogger() {
        return Functions.getFunctionsElement().getLogger();
    }

    public static boolean isTraceEnabled() {
        return Functions.getLogger().isTraceEnabled();
    }

    public static boolean isInfoEnabled() {
        return Functions.getLogger().isInfoEnabled();
    }

    public static boolean isDebugEnabled() {
        return Functions.getLogger().isDebugEnabled();
    }

    public static boolean isErrorEnabled() {
        return Functions.getLogger().isErrorEnabled();
    }

    public static boolean isWarnEnabled() {
        return Functions.getLogger().isWarnEnabled();
    }

    public static boolean isLogEnabled() {
        return Functions.getLogger() != null;
    }

    public static boolean isFatalEnabled() {
        return Functions.getLogger().isFatalEnabled();
    }

    protected void addToCache(IDisposable disposable) {
        disposable.dispose();
    }

    protected static void onFunctionEnter(OperationInfo operationInfo) {
        Functions.getFunctionsElement().onOperationEnter(operationInfo, (TransformContext)null);
    }

    protected static void onFunctionExit(OperationInfo operationInfo) {
        Functions.getFunctionsElement().onOperationExit(operationInfo);
    }

    protected static void onFunctionEnter(OperationInfo operationInfo, String[] names, Object[] values) {
        Functions.getFunctionsElement().onOperationEnter(operationInfo, names, values, (TransformContext)null);
    }

    protected static void onFunctionEnter(OperationInfo operationInfo, String variableName1, Object variable1, String variableName2, Object variable2) {
        Functions.getFunctionsElement().onOperationEnter(operationInfo, variableName1, variable1, variableName2, variable2, null);
    }

    protected static void onLocation(int index) {
        Functions.getFunctionsElement().onStatement(index);
    }

    protected static void onLocation2(int index, String[] names, Object[] values) {
        Functions.getFunctionsElement().onSubstatement(index, names, values);
    }

    protected static void onLocation2(int index) {
        Functions.getFunctionsElement().onSubstatement(index, OperationNode.EMPTY_NAMES, OperationNode.EMPTY_OBJECTS);
    }

    protected static void onLocationDelta(int index) {
        Functions.getFunctionsElement().onSubstatementDelta(index);
    }

    protected static void onLocationDelta(int index, String[] names, Object[] values) {
        Functions.getFunctionsElement().onSubstatementDelta(index, names, values);
    }

    public static Throwable handleException(Throwable e) throws TransformException {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof TransformException) {
            throw (TransformException)e;
        }
        if (e instanceof TransformRuntimeException) {
            throw (TransformRuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return e;
    }

    static FunctionsServiceElement getFunctionsElement() {
        FunctionsServiceElement function = (FunctionsServiceElement)functions.get();
        if (function == null) {
            function = new FunctionsServiceElement();
            functions.set(function);
        }
        return function;
    }

    public static final void setCurrentDestinationField(DataObject currentObject, int currentFieldIndex) {
    }

    static class FunctionsServiceElement
    extends AbstractServiceElement {
        Stack frames = new Stack();

        protected FunctionsServiceElement() {
            super("Functions", "Functions");
        }

        protected void onOperationEnter(OperationInfo operationInfo, List list) {
            this.frames.push(this.currentFrame);
            super.onOperationEnter(operationInfo, list);
        }

        protected void onOperationExit(OperationInfo operationInfo) {
            super.onOperationExit(operationInfo);
            this.currentFrame = (StackFrame)this.frames.pop();
        }
    }
}

