/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.BasicGenericDataObject;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.GenericMetaInfo;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformRuntimeException;

public class GenericDataObject
extends BasicGenericDataObject {
    private DataObjectSection parentSection;
    private GenericMetaInfo genericMetaInfo;
    private int fieldCount;
    private Object[] data;
    private LocationInfo locationInfo;
    private transient DataObjectMetaInfo metaInfo;
    static final long serialVersionUID = 5053794282503561124L;

    public GenericDataObject() {
    }

    public GenericDataObject(DataObjectSection parentSection, GenericMetaInfo genericMetaInfo) throws TransformRuntimeException {
        this(parentSection, GenericDataObject.locateMetaInfo(genericMetaInfo, parentSection), genericMetaInfo);
    }

    public GenericDataObject(DataObjectSection parentSection, DataObjectMetaInfo metaInfo, GenericMetaInfo genericMetaInfo) throws TransformRuntimeException {
        this(parentSection, genericMetaInfo, metaInfo.getFieldCount());
        this.metaInfo = metaInfo;
    }

    private GenericDataObject(DataObjectSection parentSection, GenericMetaInfo genericMetaInfo, int fieldCount) throws TransformRuntimeException {
        this(parentSection, fieldCount);
        this.genericMetaInfo = genericMetaInfo;
    }

    private GenericDataObject(DataObjectSection parentSection, int fieldCount) {
        this.parentSection = parentSection;
        this.fieldCount = fieldCount;
        this.data = new Object[fieldCount];
    }

    public Object clone() {
        GenericDataObject obj = (GenericDataObject)super.clone();
        this.parentSection = null;
        obj.data = (Object[])this.data.clone();
        DataObjectBase.cloneFields(this, obj, false);
        return obj;
    }

    public DataObject createNewObject() {
        GenericDataObject obj = (GenericDataObject)super.clone();
        obj.data = new Object[this.data.length];
        return obj;
    }

    public LocationInfo getLocationInfo() {
        this.locationInfo = this.getOrCreateLocationInfo(this.locationInfo);
        return this.locationInfo;
    }

    public DataObjectMetaInfo getMetaInfo() throws TransformRuntimeException {
        if (this.metaInfo == null) {
            this.metaInfo = GenericDataObject.locateMetaInfo(this.genericMetaInfo, this.parentSection);
        }
        return this.metaInfo;
    }

    private static DataObjectMetaInfo locateMetaInfo(GenericMetaInfo genericMetaInfo, DataObjectSection parentSection) throws TransformRuntimeException {
        String metaName = GenericDataObject.getMetaInfoFieldName(parentSection);
        try {
            DataObjectMetaInfo metaInfo = genericMetaInfo.getMetaInfo(metaName);
            return metaInfo;
        }
        catch (Exception e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT454", new Object[]{e.getMessage(), metaName});
            tre.setDetail(e);
            throw tre;
        }
    }

    protected final int getDataSize() {
        return this.data.length;
    }

    protected final Object getFieldAtIndex(int index) {
        return this.data[index];
    }

    protected final void setFieldAtIndex(int index, Object value) {
        this.data[index] = value;
    }

    final void checkFieldIndex(int index) throws FieldNotFoundException {
        if (index < 0 || index >= this.getFieldCount()) {
            this.throwOutOfRange(index);
        }
    }

    public boolean isNull(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        if (this.getFieldAtIndex(index) == null) {
            return !this.isDataFieldSection(index);
        }
        return false;
    }

    public void setNull(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        this.setFieldAtIndex(index, null);
    }

    public void setField(int index, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        this.checkFieldIndex(index);
        this.setFieldAtIndex(index, value);
    }

    public final Object getField0(int index) throws FieldNotFoundException {
        this.checkFieldIndex(index);
        return this.getFieldAtIndex(index);
    }

    public Object getField(int index) throws FieldNotFoundException {
        Object obj = this.getField0(index);
        if (obj == null && this.isDataFieldSection(index)) {
            obj = this.getSection(index);
        }
        return obj;
    }

    public DataObjectSection getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(DataObjectSection parentSection) {
        this.parentSection = parentSection;
    }

    public final int getFieldCount() {
        return this.fieldCount;
    }

    public DataObject createSectionElement(int sectionIndex, DataObjectSection parentSection) throws FieldNotFoundException {
        SectionMetaInfo fieldMetaInfo = (SectionMetaInfo)this.getMetaInfo().getFieldMetaInfo(sectionIndex);
        DataObjectMetaInfo dataObjectMetaInfo = fieldMetaInfo.getDataObjectMetaInfo();
        return new GenericDataObject(parentSection, dataObjectMetaInfo, this.genericMetaInfo);
    }

    static String getMetaInfoFieldName(DataObjectSection parentSection) {
        String name = null;
        if (parentSection != null) {
            name = parentSection.getQualifiedName();
        }
        FastStringBuffer out = new FastStringBuffer("META_INF$");
        if (name != null && name.length() > 0) {
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                out.append("J");
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    c = '_';
                }
                out.append(c);
            }
        }
        return out.toString();
    }

    public GenericMetaInfo getGenericMetaInfo() {
        return this.genericMetaInfo;
    }
}

