/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.util.bean.PropertyUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericHelper {
    public static Object createBeanInstance(String className) throws TransformException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new TransformException("Error instantiating " + className, e);
        }
    }

    public static void setBeanProperty(Object bean, String propertyName, Object value) throws TransformException {
        try {
            PropertyUtils.setProperty(bean, propertyName, value);
        }
        catch (Exception e) {
            throw new TransformException("Error setting property " + propertyName, e);
        }
    }

    public static Object getBeanProperty(Object bean, String propertyName) throws TransformException {
        try {
            Object value = PropertyUtils.getProperty(bean, propertyName);
            return value;
        }
        catch (Exception e) {
            throw new TransformException("Error getting property " + propertyName, e);
        }
    }

    public static Object run(Object bean, TransformContext cxt) throws TransformException {
        try {
            Object[] param;
            Method run;
            try {
                run = bean.getClass().getMethod("run", TransformContext.class);
                param = new Object[]{cxt};
            }
            catch (NoSuchMethodException e) {
                param = new Object[]{};
                run = bean.getClass().getMethod("run", new Class[0]);
            }
            Object ret = run.invoke(bean, param);
            return ret;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof TransformException) {
                throw (TransformException)targetException;
            }
            throw new TransformException(targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
    }
}

