/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericMetaInfo
implements Serializable {
    private static final String META_LOOKUP_TABLE = "metaLookupTable";
    private static final String PREFIX_META_INF = "META_INF";
    transient Map metaLookupField = null;

    public synchronized DataObjectMetaInfo getMetaInfo(String metaName) {
        try {
            DataObjectMetaInfo metaInfo;
            if (this.metaLookupField == null) {
                Field lookupFld = this.getClass().getField(META_LOOKUP_TABLE);
                this.metaLookupField = (Map)lookupFld.get(null);
                if (this.metaLookupField == null) {
                    this.updateMetaInfoLookupTable();
                }
            }
            if ((metaInfo = (DataObjectMetaInfo)this.metaLookupField.get(metaName)) == null) {
                throw TransformRuntimeException.createFormatted("SRT453", new Object[]{metaName, "Cannot find field in class " + this.getClass().getName()});
            }
            return metaInfo;
        }
        catch (Exception e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT453", new Object[]{metaName, e.getMessage()});
            tre.setDetail(e);
            throw tre;
        }
    }

    private void updateMetaInfoLookupTable() throws NoSuchFieldException, IllegalAccessException {
        this.metaLookupField = new HashMap();
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field fld = fields[i];
            String fldName = fld.getName();
            if (!fldName.startsWith(PREFIX_META_INF)) continue;
            Object value = fld.get(null);
            this.metaLookupField.put(fldName, value);
        }
        Field lookupFld = this.getClass().getField(META_LOOKUP_TABLE);
        lookupFld.set(null, this.metaLookupField);
    }
}

