/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.FieldParsingException;

public class HexBinary {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

    public static byte[] toBinary(String text) throws FieldParsingException {
        return HexBinary.hexStringToBinary(text);
    }

    public static String fromBinary(byte[] bytes) {
        return HexBinary.binaryToHexString(bytes, 0, bytes.length);
    }

    public static String fromBinary(byte[] bytes, int offset, int endOffset) {
        return HexBinary.binaryToHexString(bytes, offset, endOffset);
    }

    private static byte[] hexStringToBinary(String s) throws FieldParsingException {
        int len = s.length();
        if (len % 2 != 0) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT191", new Object[]{s, new Integer(len)});
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = HexBinary.hexToBin(s.charAt(i));
            int l = HexBinary.hexToBin(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw FieldParsingException.createFieldParsingExceptionFormatted("SRT190", new Object[]{s, s.substring(i, i + 2)});
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    private static String binaryToHexString(byte[] data, int offset, int length) {
        FastStringBuffer r = new FastStringBuffer(length * 2);
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            byte b = data[i];
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }
}

