/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.io.MemoryCacheSeekableStream;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StreamBaseInputSource;
import com.tplus.transform.runtime.SubRawMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;

public class InputStreamRawMessage
extends StreamBaseInputSource {
    protected transient long maxPositionRead = -1L;
    boolean eof;
    private InputStream inputStream;
    private InputStream initialInputStream;
    private static final long MAX_SEEK_BACK = Integer.MAX_VALUE;
    private boolean memoryCached;
    int bufferSize;
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private static final long serialVersionUID = 1L;

    public InputStreamRawMessage(boolean isMemoryCached) throws TransformException {
        this.memoryCached = isMemoryCached;
    }

    public InputStreamRawMessage(InputStream inputStream, boolean isMemoryCached) throws TransformException {
        this.memoryCached = isMemoryCached;
        this.initialInputStream = inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected InputStream createStream() throws IOException {
        if (this.initialInputStream == null) {
            throw new IOException("Stream not initialized");
        }
        return this.initialInputStream;
    }

    protected InputStream getAsStream0() throws IOException {
        this.initStream();
        if (this.memoryCached) {
            MemoryCacheSeekableStream memoryCacheSeekableStream = (MemoryCacheSeekableStream)this.inputStream;
            this.seekTo(memoryCacheSeekableStream, 0L);
        }
        return this.inputStream;
    }

    private void initStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.createStream();
            if (this.memoryCached) {
                this.inputStream = new MemoryCacheSeekableStream(this.inputStream, this.bufferSize);
            }
        }
    }

    public int getLength() throws TransformException {
        if (this.eof) {
            return (int)this.maxPositionRead;
        }
        throw new TransformException("Length of the RawMessage is not known");
    }

    public long getLongLength() throws TransformException {
        return this.getLength();
    }

    public RawMessage subMessage(long start_index, int num_chars) throws TransformException {
        return new SubRawMessage(this, start_index, num_chars);
    }

    public int getByte0(long at) throws TransformException {
        try {
            this.checkSeek(at);
            int read = this.read();
            if (read < 0) {
                this.eof = true;
                return -1;
            }
            this.positionRead(at);
            return read;
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public int getBytes0(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        try {
            this.checkSeek(start_index);
            int bytes = this.readAll(toRet, destLocation, num_chars);
            if (bytes < num_chars) {
                this.eof = true;
            }
            this.positionRead(start_index + (long)bytes);
            return bytes;
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private int readAll(byte[] toRet, int destLocation, int num_chars) throws IOException {
        int bytes;
        int readCount = 0;
        while ((bytes = this.read(toRet, destLocation + readCount, num_chars - readCount)) >= 0 && (readCount += bytes) < num_chars) {
        }
        return readCount;
    }

    protected void positionRead(long pos) {
        long newPosition = pos + 1L;
        if (this.maxPositionRead < newPosition) {
            this.maxPositionRead = newPosition;
        }
    }

    private void checkSeek(long start_index) throws TransformException, IOException {
        this.initStream();
        if (this.memoryCached) {
            MemoryCacheSeekableStream memoryCacheSeekableStream = (MemoryCacheSeekableStream)this.inputStream;
            this.seekTo(memoryCacheSeekableStream, start_index);
        } else {
            if (start_index == this.maxPositionRead) {
                return;
            }
            if (start_index > this.maxPositionRead) {
                this.skip(start_index - this.maxPositionRead);
            }
            if (start_index < this.maxPositionRead) {
                throw new TransformException("Random seek not supported in a stream based message. Attempt to read from position " + start_index + " when current position is " + this.maxPositionRead);
            }
        }
    }

    private void seekTo(MemoryCacheSeekableStream memoryCacheSeekableStream, long start_index) throws IOException {
        if (this.maxPositionRead - start_index > Integer.MAX_VALUE) {
            throw new IOException("Random seek above specified buffer limit not supported. Attempt to read from position " + start_index + " when current position is " + this.maxPositionRead);
        }
        memoryCacheSeekableStream.seek(start_index);
    }

    private long skip(long n) throws IOException {
        int nr;
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public void dispose() throws TransformException {
        this.closeStream();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.closeStream();
        out.defaultWriteObject();
    }

    private int read(byte[] buf) throws IOException {
        int read = this.inputStream.read(buf);
        return read;
    }

    private int read(byte[] toRet, int destLocation, int num_chars) throws IOException {
        return this.inputStream.read(toRet, destLocation, num_chars);
    }

    private int read() throws IOException {
        return this.inputStream.read();
    }

    protected void closeStream() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.inputStream = null;
        if (this.initialInputStream != null) {
            try {
                this.initialInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.initialInputStream = null;
    }
}

