/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractDataObjectBase;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;

public abstract class InternalMessageValidationRules
extends AbstractValidationRules {
    protected InternalMessageValidationRules(AbstractServiceElement serviceElement) {
        super(serviceElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate(DataObject no, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.setExceptionHandler(exceptionHandler);
            this.validate0(no);
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    protected abstract void validate0(DataObject var1) throws TransformException;

    protected void checkNotNull(NormalizedObject nObj) throws TransformException {
        DataObjectMetaInfo metaInfo = nObj.getMetaInfo();
        int count = metaInfo.getFieldCount();
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo fieldInfo = metaInfo.getFieldMetaInfo(i);
            if (metaInfo.isSection(i)) {
                DataObjectSection dataObjectSection = nObj.getSection(i);
                this.assertConstraints(dataObjectSection);
                int n = dataObjectSection.getElementCount();
                for (int j = 0; j < n; ++j) {
                    this.checkNotNull((NormalizedObject)dataObjectSection.getElement(j));
                }
                continue;
            }
            if (fieldInfo.isOptional()) continue;
            this.assertNotNull(nObj, i);
        }
    }

    private void assertNotNull(NormalizedObject nObj, int index) throws TransformException {
        if (nObj.isNull(index)) {
            FieldNullException fne = FieldNullException.createFieldNullExceptionFormatted("SRT600", nObj.getQualifiedName(index));
            fne.setField(nObj, index, null);
            throw fne;
        }
    }

    protected void assertNotNull(AbstractDataObjectBase obj, int index) throws TransformException {
        try {
            obj.assertNotNull(index);
        }
        catch (TransformException e) {
            this.getExceptionHandler().onException(e);
        }
    }

    protected void assertConstraints(DataObjectSection sec) throws TransformException {
        try {
            sec.assertConstraints();
        }
        catch (TransformException e) {
            this.getExceptionHandler().onException(e);
        }
    }
}

