/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractTrigger;
import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.NormalizedObjectMappingFormat;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.handler.TriggerContext;
import java.rmi.RemoteException;
import javax.naming.NamingException;

public class InternalRouterTrigger
extends AbstractTrigger {
    NormalizedObjectMappingFormat internaMessageMappingFormat = null;
    BusinessTransaction destinationInternalMessageFormat;
    String internalMsgMappingName;

    public void setContext(TriggerContext cxt) {
        super.setContext(cxt);
        try {
            this.internalMsgMappingName = (String)cxt.getProperty("internalmapping.format");
            this.initNormalizedObjectMappingFormat();
        }
        catch (Exception e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT452");
            tre.setDetail(e);
            throw tre;
        }
    }

    public void onBatchStart(TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            this.destinationInternalMessageFormat.onBatchStart(tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void onNewMessage(NormalizedObject obj, TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            NormalizedObject destinationNo = this.internaMessageMappingFormat.map(obj, tcxt);
            this.destinationInternalMessageFormat.handleNormalizedObject(destinationNo, tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void onBatchEnd(TransformContext tcxt) throws TransformException {
        try {
            tcxt = this.getTransformContext(tcxt);
            this.destinationInternalMessageFormat.onBatchEnd(tcxt);
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT450", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    void initNormalizedObjectMappingFormat() throws NamingException, RemoteException {
        if (this.internaMessageMappingFormat == null) {
            this.internaMessageMappingFormat = this.getTriggerContext().lookupNormalizedObjectMappingFormat(this.internalMsgMappingName);
            this.destinationInternalMessageFormat = this.getTriggerContext().lookupBusinessTransaction(this.internaMessageMappingFormat.getDestinationMessageName());
        }
    }
}

