/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.CommentInfo;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.Locator;
import com.tplus.transform.runtime.LocatorImpl;
import com.tplus.transform.runtime.TransformContext;

public class LocationInfoImpl
implements LocationInfo {
    private DataObject obj;
    Locator[] fieldLocators;
    CommentInfo[] comments;
    Locator locator;
    CommentInfo comment;

    public LocationInfoImpl(DataObject obj) {
        this.obj = obj;
    }

    private void createLocators(DataObject obj) {
        if (this.fieldLocators == null) {
            this.fieldLocators = new LocatorImpl[obj.getFieldCount()];
        }
    }

    private void createComments(DataObject obj) {
        if (this.comments == null) {
            this.comments = new CommentInfo[obj.getFieldCount()];
        }
    }

    public Locator getFieldLocation(int fieldIndex) {
        if (this.fieldLocators != null) {
            return this.fieldLocators[fieldIndex];
        }
        return null;
    }

    public Locator getFieldLocation(String fieldName) {
        return this.getFieldLocation(this.obj.getFieldIndex(fieldName));
    }

    public void setFieldLocation(int fieldIndex, Locator locator) {
        this.createLocators(this.obj);
        this.fieldLocators[fieldIndex] = locator;
    }

    public void setFieldLocation(String fieldName, Locator locator) {
        this.setFieldLocation(this.obj.getFieldIndex(fieldName), locator);
    }

    public CommentInfo getComment() {
        return this.comment;
    }

    public void addComment(String commentStr) {
        if (this.comment == null) {
            this.comment = new CommentInfo();
        }
        this.comment.addComment(commentStr);
    }

    public CommentInfo getComment(int fieldIndex) {
        if (this.comments != null) {
            return this.comments[fieldIndex];
        }
        return null;
    }

    public CommentInfo getComment(String fieldName) {
        return this.getComment(this.obj.getFieldIndex(fieldName));
    }

    public void addComment(int fieldIndex, String comment) {
        this.createComments(this.obj);
        if (fieldIndex > this.comments.length) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT168", String.valueOf(fieldIndex));
        }
        CommentInfo commentInfo = this.comments[fieldIndex];
        if (commentInfo == null) {
            this.comments[fieldIndex] = commentInfo = new CommentInfo();
        }
        commentInfo.addComment(comment);
    }

    public void addComment(String fieldName, String comment) {
        this.addComment(this.obj.getFieldIndex(fieldName), comment);
    }

    public Locator getLocation() {
        return this.locator;
    }

    public void setLocation(Locator locator) {
        this.locator = locator;
    }

    public static boolean isLocationInfo(TransformContext cxt) {
        if (cxt != null) {
            String locstr = (String)cxt.getProperty("locationInfo");
            return locstr != null && locstr.equals("true");
        }
        return false;
    }
}

