/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BatchMessage;
import com.tplus.transform.runtime.ExternalMessage;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.Message;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.MessageMapping;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.ServiceElement;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;

public class LookupCache {
    private ServiceElement serviceElement;
    LookupContext lcxt;
    Map lookupCache = new HashMap(5);
    protected static Log log = LogFactory.getLog(LookupCache.class);

    public LookupCache(ServiceElement serviceElement, LookupContext lcxt) {
        this.serviceElement = serviceElement;
        this.lcxt = lcxt;
    }

    public LookupContext getLookupContext() {
        return this.lcxt;
    }

    public Object lookupGeneric(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj != null) {
            return obj;
        }
        Message toRet = this.getLookupContext().lookupMessage(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public Object createServiceObject(String name, String className) throws NamingException, RemoteException {
        try {
            Object obj = this.lookupCache.get(name);
            Class<?> reportClass = Class.forName(className, false, this.serviceElement.getClass().getClassLoader());
            if (reportClass.isInstance(obj)) {
                return obj;
            }
            obj = reportClass.newInstance();
            this.lookupCache.put(name, obj);
            return obj;
        }
        catch (Exception e) {
            log.error("Error creating '" + name + "'", e);
            throw new NamingException("Error creating '" + name + "'");
        }
    }

    public Message lookupMessage(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof Message) {
            return (Message)obj;
        }
        Message toRet = this.getLookupContext().lookupMessage(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public ExternalMessage lookupExternalMessage(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof ExternalMessage) {
            return (ExternalMessage)obj;
        }
        ExternalMessage toRet = this.getLookupContext().lookupExternalMessage(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public BatchMessage lookupBatchMessage(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof BatchMessage) {
            return (BatchMessage)obj;
        }
        BatchMessage toRet = this.getLookupContext().lookupBatchMessage(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public InternalMessage lookupInternalMessage(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof InternalMessage) {
            return (InternalMessage)obj;
        }
        InternalMessage toRet = this.getLookupContext().lookupInternalMessage(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public MessageMapping lookupMessageMapping(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof MessageMapping) {
            return (MessageMapping)obj;
        }
        MessageMapping toRet = this.getLookupContext().lookupMessageMapping(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public MessageFlow lookupMessageFlow(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof MessageFlow) {
            return (MessageFlow)obj;
        }
        MessageFlow toRet = this.getLookupContext().lookupMessageFlow(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public PersistenceManager lookupPersistenceManager(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof PersistenceManager) {
            return (PersistenceManager)obj;
        }
        PersistenceManager toRet = this.getLookupContext().lookupPersistenceManager(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public OutputProtocol lookupOutputProtocol(String name) throws NamingException {
        Object obj = this.lookupCache.get(name);
        if (obj instanceof OutputProtocol) {
            return (OutputProtocol)obj;
        }
        OutputProtocol toRet = this.getLookupContext().lookupOutputProtocol2(name);
        this.lookupCache.put(name, toRet);
        return toRet;
    }

    public void cleanup() {
        for (Map.Entry entry : this.lookupCache.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
        }
    }
}

