/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.runtime.vm.ThreadInfo;
import com.tplus.transform.runtime.vm.VolanteVM;
import com.tplus.transform.runtime.vm.VolanteVMImpl;
import com.tplus.transform.util.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class LookupContextFactory {
    public static final String TRANSFORM_PROPERTIES = "/transform.properties";
    public static final String TRANSFORM_SERVER_PROPERTIES = "/transformserver.properties";
    public static final String LOOKUP_FACTORY_PROPERTY = "tplus.transform.lookup.factory";
    private static LookupContextFactory defaultFactory;
    private static Hashtable defaultProperties;
    public static final String POOLED = "pooled";
    protected static Log log;
    private static boolean alwaysUseDefault;

    public static void setDefaultFactory(LookupContextFactory lookupContextFactory) {
        defaultFactory = lookupContextFactory;
        defaultProperties = new Hashtable();
        alwaysUseDefault = true;
    }

    public static synchronized LookupContext getLookupContext() throws NamingException {
        Class entityClass = LookupContextFactory.getActiveEntityClass();
        if (entityClass != null) {
            return LookupContextFactory.getLookupContext(entityClass);
        }
        return LookupContextFactory.getDefaultLookupContext();
    }

    private static Class getActiveEntityClass() throws NamingException {
        OperationInfo operationInfo;
        StackFrame frame;
        ThreadInfo threadInfo;
        VolanteVM volanteVM = VolanteVMImpl.getInstance();
        if (volanteVM != null && (threadInfo = volanteVM.getThreadInfo()) != null && (frame = threadInfo.getStackFrame()) != null && (operationInfo = frame.getOperationInfo()) != null) {
            EntityInfo entityInfo = operationInfo.getEntityInfo();
            Class entityClass = entityInfo.getEntityClass();
            return entityClass;
        }
        return null;
    }

    public static synchronized LookupContext getLookupContext(Class cls) throws NamingException {
        ClassLoader loader = LookupContextFactory.getClassLoader(cls);
        return LookupContextFactory.getLookupContext(loader);
    }

    public static synchronized LookupContext getLookupContext(ClassLoader loader) throws NamingException {
        if (loader == LookupContextFactory.getClassLoader(LookupContextFactory.class) || alwaysUseDefault) {
            return LookupContextFactory.getDefaultLookupContext();
        }
        Properties props = LookupContextFactory.loadTransformProperties(loader);
        LookupContextFactory factoryToUse = LookupContextFactory.createLookupContextFactory(loader, props);
        return factoryToUse.createLookupContext(props);
    }

    static LookupContext getDefaultLookupContext() throws NamingException {
        LookupContextFactory.loadDefaultFactory();
        return defaultFactory.createLookupContext(defaultProperties);
    }

    public static LookupContext getLookupContext(Hashtable props) throws NamingException {
        return LookupContextFactory.getLookupContext(LookupContextFactory.class, props);
    }

    public static LookupContext getLookupContext(Class cls, Hashtable props) throws NamingException {
        LookupContextFactory factoryToUse;
        String lookupFactoryClassName = (String)props.get(LOOKUP_FACTORY_PROPERTY);
        if (lookupFactoryClassName != null) {
            factoryToUse = LookupContextFactory.createLookupContextFactory(LookupContextFactory.getClassLoader(cls), props);
        } else {
            LookupContextFactory.loadDefaultFactory();
            Hashtable allProps = new Hashtable(props);
            allProps.putAll(defaultProperties);
            props = allProps;
            factoryToUse = defaultFactory;
        }
        return factoryToUse.createLookupContext(props);
    }

    private static synchronized void loadDefaultFactory() throws NamingException {
        if (defaultFactory == null) {
            ClassLoader classLoader = LookupContextFactory.getClassLoader(LookupContextFactory.class);
            defaultProperties = LookupContextFactory.loadTransformProperties(classLoader);
            defaultFactory = LookupContextFactory.createLookupContextFactory(classLoader, defaultProperties);
        }
    }

    private static ClassLoader getClassLoader(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private static Properties loadTransformProperties(ClassLoader classLoader) throws NamingException {
        Properties props = LookupContextFactory.loadProperties(classLoader, TRANSFORM_PROPERTIES);
        try {
            Properties props2 = LookupContextFactory.loadProperties(classLoader, TRANSFORM_SERVER_PROPERTIES);
            props.putAll((Map<?, ?>)props2);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return props;
    }

    private static Properties loadProperties(ClassLoader classLoader, String resourceName) throws NamingException {
        resourceName = resourceName.substring(1);
        InputStream is = classLoader.getResourceAsStream(resourceName);
        try {
            if (is == null) {
                throw StandardRuntimeResource.createNamingExceptionFormatted("SRT475", new Object[]{resourceName});
            }
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw StandardRuntimeResource.createNamingExceptionFormatted("SRT476", new Object[]{resourceName, e.getMessage()});
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static LookupContextFactory createLookupContextFactory(ClassLoader classLoader, Hashtable props) throws NamingException {
        String lookupFactoryClassName = (String)props.get(LOOKUP_FACTORY_PROPERTY);
        if (lookupFactoryClassName == null) {
            throw StandardRuntimeResource.createNamingExceptionFormatted("SRT477", new Object[]{LOOKUP_FACTORY_PROPERTY});
        }
        try {
            Class<?> cls = Class.forName(lookupFactoryClassName, true, classLoader);
            LookupContextFactory factory = (LookupContextFactory)cls.newInstance();
            return factory;
        }
        catch (Exception e) {
            throw StandardRuntimeResource.createNamingExceptionFormatted("SRT478", new Object[]{lookupFactoryClassName, e.getMessage()});
        }
    }

    public abstract LookupContext createLookupContext(Hashtable var1) throws NamingException;

    public static String fixProtocolName(String name) {
        if (name.equals("rmi") || name.equals("queue")) {
            return name + "protocol";
        }
        return name;
    }

    static {
        log = LogFactory.getRuntimeLog();
    }
}

