/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractMessageMapping;
import com.tplus.transform.runtime.AbstractRules;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.CustomExternalClassSupport;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMapper;
import com.tplus.transform.runtime.MappingInfo;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.WeakClassLocal;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.csv.CSVException;
import com.tplus.transform.util.csv.CSVParser;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public abstract class MappingRules
extends AbstractRules {
    static WeakClassLocal mappingInfoClassLocal = new WeakClassLocal();
    MappingInfo mappingInfo;
    protected CustomExternalClassSupport customExternalClassSupport;
    private DataObject currentObject;
    private int currentFieldIndex;
    DataObjectMetaInfo multiSourceInputMetaInfo;
    DataObjectMetaInfo multiSourceOutputMetaInfo;

    MappingRules(AbstractServiceElement serviceElement) {
        super(serviceElement);
        this.setLogger(LogFactory.getMappingLog(serviceElement, serviceElement.getEntityName()));
        this.initializeMappingInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMappingInfo() {
        try {
            Class<?> thisClass;
            Class<?> clazz = thisClass = this.getClass();
            synchronized (clazz) {
                this.mappingInfo = (MappingInfo)mappingInfoClassLocal.get(thisClass);
                if (this.mappingInfo == null) {
                    this.mappingInfo = MappingRules.readMappingInfo(thisClass);
                    mappingInfoClassLocal.put(thisClass, this.mappingInfo);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().unexpectedError(e);
        }
    }

    protected void setup(TransformContext cxt) {
        super.setup(cxt);
        this.currentObject = null;
        this.currentFieldIndex = -1;
    }

    protected void teardown(TransformContext cxt) {
        super.teardown(cxt);
        this.currentObject = null;
        this.currentFieldIndex = -1;
    }

    public final void setCurrentDestinationField(DataObject currentObject, int currentFieldIndex) {
        this.currentObject = currentObject;
        this.currentFieldIndex = currentFieldIndex;
        if (this.isTraceEnabled() && currentObject != null && currentFieldIndex != -1 && currentObject.getFieldCount() > currentFieldIndex) {
            this.getLogger().trace("Executing mapping for " + currentObject.getFieldID(currentFieldIndex));
        }
    }

    protected void handleUnexpectedException(RuntimeException e) {
        e.printStackTrace();
        TransformRuntimeException tre = e instanceof TransformRuntimeException ? (TransformRuntimeException)e : new TransformRuntimeException("Unexpected exception while executing mapping", e);
        if (this.currentObject != null && this.currentFieldIndex != -1 && this.currentObject.getFieldCount() > this.currentFieldIndex) {
            String qName = this.currentObject.getQualifiedName(this.currentFieldIndex);
            String fieldId = this.currentObject.getFieldID(this.currentFieldIndex);
            tre.setContextProperty("Mapping-Field", qName);
            tre.setContextProperty("Error-Field", qName);
            tre.setContextProperty("Error-Field-ID", fieldId);
        }
        tre.setContextProperty("Error-Type", "Mapping");
        throw tre;
    }

    public MappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    protected Object invokeCustomExternalClass(String className, Object[] args, TransformContext cxt) throws TransformException {
        if (this.customExternalClassSupport == null) {
            this.customExternalClassSupport = new CustomExternalClassSupport(this.getClass().getClassLoader());
        }
        return this.customExternalClassSupport.invoke(className, args, cxt);
    }

    protected DataObjectMetaInfo prepareMultiSourceInputMetaInfo(DesignerType[] types) {
        this.multiSourceInputMetaInfo = AbstractMessageMapping.prepareDataObjectMetaInfo(types);
        return this.multiSourceInputMetaInfo;
    }

    protected DataObjectMetaInfo prepareMultiSourceInputMetaInfo(String[] args, DesignerType[] types) {
        this.multiSourceInputMetaInfo = AbstractMessageMapping.prepareDataObjectMetaInfo(args, types);
        return this.multiSourceInputMetaInfo;
    }

    protected DataObjectMetaInfo prepareMultiSourceOutputMetaInfo(DesignerType[] types) {
        this.multiSourceOutputMetaInfo = AbstractMessageMapping.prepareDataObjectMetaInfo(types);
        return this.multiSourceOutputMetaInfo;
    }

    protected DataObjectMetaInfo prepareMultiSourceOutputMetaInfo(String[] args, DesignerType[] types) {
        this.multiSourceOutputMetaInfo = AbstractMessageMapping.prepareDataObjectMetaInfo(args, types);
        return this.multiSourceOutputMetaInfo;
    }

    protected DataObject createInputDataObject() throws TransformException {
        if (this.multiSourceInputMetaInfo != null) {
            SimpleGenericDataObject2 object = new SimpleGenericDataObject2(this.multiSourceInputMetaInfo);
            return object;
        }
        throw new TransformException("createInputDataObject is support only for multi-source mapping");
    }

    protected DataObject createOutputDataObject() throws TransformException {
        if (this.multiSourceOutputMetaInfo != null) {
            SimpleGenericDataObject2 object = new SimpleGenericDataObject2(this.multiSourceOutputMetaInfo);
            return object;
        }
        throw new TransformException("createOutputDataObject is support only for multi-source mapping");
    }

    private static MappingInfo readMappingInfo(Class cls) throws TransformException {
        String className = cls.getName();
        int lastDot = className.lastIndexOf(46);
        String name = (lastDot == -1 ? className : className.substring(lastDot + 1)) + ".csv";
        return MappingRules.readMappingInfo(cls, name);
    }

    public static MappingInfo readMappingInfo(Class cls, String resource) throws TransformException {
        try {
            InputStream is = cls.getResourceAsStream(resource);
            if (is != null) {
                MappingInfoImpl mappingInfo = new MappingInfoImpl();
                List mappingInfoList = CSVParser.parse(is, ",");
                for (int i = 0; i < mappingInfoList.size(); ++i) {
                    String[] mappingData = (String[])mappingInfoList.get(i);
                    for (int j = 1; j < mappingData.length; ++j) {
                        String srcField = mappingData[j];
                        mappingInfo.addMapping(mappingData[0], srcField);
                    }
                }
                return mappingInfo;
            }
            return null;
        }
        catch (CSVException e) {
            TransformException te = TransformException.createFormatted("SRT645");
            te.setDetail(e);
            throw te;
        }
    }

    static class MappingInfoImpl
    implements MappingInfo,
    Serializable {
        FieldMapper forwardMap = new FieldMapper();
        FieldMapper reverseMap = new FieldMapper();

        MappingInfoImpl() {
        }

        public String srcNameToDest(String srcField) {
            return this.forwardMap.mapFieldSingle(srcField);
        }

        public String destNameToSrc(String destField) {
            return this.reverseMap.mapFieldSingle(destField);
        }

        public String srcIDToDest(String srcFieldID) {
            return this.forwardMap.mapIDSingle(srcFieldID);
        }

        public String destIDToSrc(String destFieldID) {
            return this.reverseMap.mapIDSingle(destFieldID);
        }

        public List srcNameToDestNames(String srcField) {
            return this.forwardMap.mapField(srcField);
        }

        public List destNameToSrcNames(String destField) {
            return this.reverseMap.mapField(destField);
        }

        public List srcIDToDestIDs(String srcFieldID) {
            return this.forwardMap.mapID(srcFieldID);
        }

        public List destIDToSrcIDs(String destFieldID) {
            return this.reverseMap.mapID(destFieldID);
        }

        void addMapping(String destField, String srcField) {
            this.reverseMap.addToMap(destField, srcField);
            this.forwardMap.addToMap(srcField, destField);
        }
    }

    static class SimpleGenericDataObject2
    extends SimpleGenericDataObject
    implements NormalizedObject {
        public SimpleGenericDataObject2(DataObjectMetaInfo info) {
            super(info);
        }
    }
}

