/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.RawInputOutputMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class MemoryRawOutputMessage
extends AbstractRawMessage
implements RawInputOutputMessage,
OutputDevice {
    CharBinaryBuffer charBinaryBuffer = new CharBinaryBuffer(40);

    public MemoryRawOutputMessage(String encoding) throws TransformRuntimeException {
        if (encoding != null) {
            super.setEncoding(encoding);
            MemoryRawOutputMessage.verifyEncoding(encoding);
            this.charBinaryBuffer.setEncoding(encoding);
        }
    }

    public void append(byte[] bytes) throws TransformException {
        this.charBinaryBuffer.append(bytes);
    }

    public void append(String bytes) throws TransformException {
        this.charBinaryBuffer.append(bytes);
    }

    public void append(RawMessage message) throws TransformException {
        this.write(MemoryRawOutputMessage.getAsBytesOrString(message));
    }

    public void write(Object data) throws TransformException {
        if (data instanceof RawMessage) {
            if (!this.charBinaryBuffer.isEmpty()) {
                MemoryRawOutputMessage.copyProperties((RawMessage)data, this);
            }
            this.write(MemoryRawOutputMessage.getAsBytesOrString((RawMessage)data));
        } else if (data instanceof byte[]) {
            this.charBinaryBuffer.append((byte[])data);
        } else if (data instanceof Binary) {
            this.charBinaryBuffer.append(((Binary)data).getAsBytes());
        } else if (data instanceof String) {
            this.charBinaryBuffer.append((String)data);
        } else if (data instanceof StringBuffer) {
            this.charBinaryBuffer.append((StringBuffer)data);
        } else if (data instanceof FastStringBuffer) {
            this.charBinaryBuffer.append((FastStringBuffer)data);
        } else if (data instanceof char[]) {
            this.charBinaryBuffer.append((char[])data);
        } else {
            throw TransformException.createFormatted("SRT425", data.getClass().getName());
        }
    }

    public int getLength() {
        if (this.isBinaryData()) {
            return this.getAsBytes0().length;
        }
        return this.getAsString0().length();
    }

    public boolean isBinary() {
        return this.isBinaryData();
    }

    public InputStream getAsStream() throws TransformException {
        return new ByteArrayInputStream(this.getAsBytes());
    }

    public Object getAsObject() {
        if (this.isBinaryData()) {
            return this.getAsBytes0();
        }
        return this.getAsString0();
    }

    public byte[] getAsBytes0() {
        return this.charBinaryBuffer.toByteArray();
    }

    public String getAsString0() {
        return this.charBinaryBuffer.getAsString();
    }

    public boolean isBinaryData() {
        return this.charBinaryBuffer.isBinaryData();
    }

    public void clear() {
        super.clearProperties();
        super.removeAllAttachments();
        this.charBinaryBuffer.setLength(0);
    }
}

