/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.Callable;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.Delegator;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import java.io.Serializable;

public class MessageHandlerDelegate
implements MessageHandler,
Serializable {
    MessageHandler messageHandler;
    private Delegator delegator;

    public MessageHandlerDelegate(Delegator delegator, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.delegator = delegator;
    }

    public boolean handleMessage(DataObject obj, TransformContext cxt) throws TransformException {
        try {
            Boolean ret = (Boolean)this.delegator.call(new HandlerCallable(obj, cxt));
            return ret;
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private class HandlerCallable
    implements Callable,
    Serializable {
        private final DataObject obj;
        private final TransformContext cxt;

        public HandlerCallable(DataObject obj, TransformContext cxt) {
            this.obj = obj;
            this.cxt = cxt;
        }

        public Object call() throws TransformException {
            boolean b = MessageHandlerDelegate.this.messageHandler.handleMessage(this.obj, this.cxt);
            return b;
        }
    }
}

