/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.CascadedOperation;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.OperationContext;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OperationExecutor {
    public static Result execute(OperationContext operationContext, CascadedOperation cascadedOperation) throws RemoteException {
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        try {
            Object output = cascadedOperation.run(cascadingExceptionHandler);
            List exceptions = cascadingExceptionHandler.getExceptions();
            OperationExecutor.updateExceptionTrace(operationContext, exceptions);
            return new Result(output, exceptions);
        }
        catch (TransformException e) {
            ArrayList allExceptions = new ArrayList(cascadingExceptionHandler.getExceptions());
            allExceptions.addAll(e.getExceptionsAsList());
            return new Result(null, OperationExecutor.updateExceptionTrace(operationContext, allExceptions));
        }
        catch (TransformRuntimeException e) {
            OperationExecutor.addTraceToException(operationContext, e);
            throw e;
        }
    }

    public static Object execute0(OperationContext operationContext, CascadedOperation cascadedOperation) throws RemoteException, TransformException {
        ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
        try {
            Object output = cascadedOperation.run(exceptionHandler);
            return output;
        }
        catch (TransformException e) {
            OperationExecutor.addTraceToException(operationContext, e);
            throw e;
        }
        catch (TransformRuntimeException e) {
            OperationExecutor.addTraceToException(operationContext, e);
            throw e;
        }
    }

    protected static void addTraceToException(OperationContext operationContext, TransformException e) {
        e.addTrace(operationContext.getEntityType(), operationContext.getEntityName(), operationContext.getActiveElementName());
    }

    protected static void addTraceToException(OperationContext operationContext, TransformRuntimeException e) {
        e.addTrace(operationContext.getEntityType(), operationContext.getEntityName(), operationContext.getActiveElementName());
    }

    protected static List updateExceptionTrace(OperationContext operationContext, List exceptions) {
        return TransformException.updateExceptionTrace(exceptions, operationContext.getEntityType(), operationContext.getEntityName(), operationContext.getActiveElementName());
    }
}

