/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.LocationManager;
import com.tplus.transform.util.log.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;

public abstract class OperationNode
implements Serializable {
    protected transient AbstractServiceElement serviceElement;
    transient LocationManager instanceLocationManager;
    static final String[] EMPTY_NAMES = new String[0];
    static final Object[] EMPTY_OBJECTS = new Object[0];
    private boolean traceEnabled;
    private transient Log log;

    public OperationNode(AbstractServiceElement serviceElement) {
        this.serviceElement = serviceElement;
        this.instanceLocationManager = this.getLocationManager();
    }

    public Log getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getRuntimeLog();
        }
        return this.log;
    }

    protected void setLogger(Log log) {
        this.log = log;
        this.traceEnabled = log.isTraceEnabled();
    }

    protected boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    protected boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    protected boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    protected boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    protected boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    protected boolean isLogEnabled() {
        return this.getLogger() != null;
    }

    protected boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    protected void onStartOperation() {
        if (this.log != null) {
            this.traceEnabled = this.log.isTraceEnabled();
        }
    }

    protected String getEntityName() {
        if (this.serviceElement != null) {
            return this.serviceElement.getEntityName();
        }
        return null;
    }

    protected void onLocation(int index) {
        this.instanceLocationManager.onLocation(index, this.serviceElement);
    }

    protected void onLocation(int index, DataObject obj, int fldIndex) {
        if (obj != null && fldIndex != -1) {
            Object value = obj.getField(fldIndex);
            String fieldId = obj.getFieldID(fldIndex);
            String[] $VALUES = new String[]{"$value (" + fieldId + ")"};
            this.instanceLocationManager.onLocation(index, $VALUES, new Object[]{value}, this.serviceElement);
        } else {
            this.instanceLocationManager.onLocation(index, this.serviceElement);
        }
    }

    protected void onLocation(int index, String[] names, Object[] values) {
        this.instanceLocationManager.onLocation(index, names, values, this.serviceElement);
    }

    protected void onLocation2(int index, String[] names, Object[] values) {
        this.instanceLocationManager.onLocation2(index, names, values, this.serviceElement);
    }

    protected void onLocation2(int index) {
        this.instanceLocationManager.onLocation2(index, EMPTY_NAMES, EMPTY_OBJECTS, this.serviceElement);
    }

    protected void onLocationDelta(int index) {
        this.instanceLocationManager.onLocationDelta(index, this.serviceElement);
    }

    protected void onLocationDelta(int index, String[] names, Object[] values) {
        this.instanceLocationManager.onLocationDelta(index, names, values, this.serviceElement);
    }

    public List getLocations() {
        return this.instanceLocationManager.getLocations();
    }

    protected LocationManager getLocationManager() {
        return LocationManager.EMPTY;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.instanceLocationManager = this.getLocationManager();
    }
}

