/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.CustomClassSupport;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.MappingRules;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.handler.IOutputMapping;

public abstract class OutputMappingRules
extends MappingRules {
    protected String customMappingClassName;
    private IOutputMapping customMapping;

    public OutputMappingRules(AbstractServiceElement serviceElement) {
        super(serviceElement);
    }

    public void mapFields(NormalizedObject normalizedObj, ExternalObject externalObject, TransformContext cxt) throws TransformException {
        this.mapHeaderFields(normalizedObj, externalObject.getHeader(), externalObject, cxt);
        this.mapDataFields(normalizedObj, externalObject.getData(), externalObject, cxt);
        this.mapTrailerFields(normalizedObj, externalObject.getData(), externalObject.getTrailer(), externalObject, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapHeaderFields(NormalizedObject normalizedObj, DataObject header, ExternalObject externalObject, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.mapHeaderFields0(normalizedObj, header, externalObject, cxt);
            if (this.customMappingClassName != null) {
                this.getCustomMappingClass().mapHeader(normalizedObj, header, cxt);
            }
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapDataFields(NormalizedObject normalizedObj, DataObject data, ExternalObject externalObject, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.mapDataFields0(normalizedObj, data, externalObject, cxt);
            if (this.customMappingClassName != null) {
                this.getCustomMappingClass().mapData(normalizedObj, data, cxt);
            }
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapTrailerFields(NormalizedObject normalizedObj, DataObject data, DataObject trailer, ExternalObject externalObject, TransformContext cxt) throws TransformException {
        try {
            this.setup(cxt);
            this.mapTrailerFields0(normalizedObj, trailer, externalObject, cxt);
            if (this.customMappingClassName != null) {
                this.getCustomMappingClass().mapTrailer(data, trailer, cxt);
            }
        }
        catch (RuntimeException e) {
            this.handleUnexpectedException(e);
        }
        finally {
            this.teardown(cxt);
        }
    }

    public void mapHeaderFields0(NormalizedObject normalizedObj, DataObject header, ExternalObject externalObject, TransformContext cxt) throws TransformException {
    }

    public abstract void mapDataFields0(NormalizedObject var1, DataObject var2, ExternalObject var3, TransformContext var4) throws TransformException;

    public void mapTrailerFields0(NormalizedObject normalizedObj, DataObject trailer, ExternalObject externalObject, TransformContext cxt) throws TransformException {
    }

    private IOutputMapping getCustomMappingClass() throws TransformException {
        if (this.customMapping == null) {
            this.customMapping = (IOutputMapping)CustomClassSupport.createInstance(this.customMappingClassName, this.getClass().getClassLoader(), IOutputMapping.class);
        }
        return this.customMapping;
    }
}

