/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.FileInputOutputMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.RawOutputMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class OutputStreamRawMessage
extends AbstractRawMessage
implements RawOutputMessage {
    OutputStream outputStream;

    public OutputStreamRawMessage(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected OutputStreamRawMessage() {
    }

    protected OutputStream createStream() throws IOException {
        return this.outputStream;
    }

    public void append(byte[] bytes) throws TransformException {
        this.append(bytes, 0, bytes.length);
    }

    public void append(byte[] bytes, int off, int len) throws TransformException {
        try {
            this.initStream();
            this.outputStream.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private void initStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.createStream();
        }
    }

    public void append(String str) throws TransformException {
        try {
            byte[] bytes = CharBinaryBuffer.stringToBytes(str, this.getEncoding());
            this.append(bytes);
        }
        catch (UnsupportedEncodingException e) {
            TransformException te = TransformException.createFormatted("SRT666");
            te.setDetail(e);
            throw te;
        }
    }

    public void append(RawMessage message) throws TransformException {
        FileInputOutputMessage.appendRawMessage(this, message);
    }

    public Object getAsObject() throws TransformException {
        return null;
    }

    public boolean isBinary() {
        return true;
    }

    public void dispose() throws TransformException {
        this.closeStream();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected void closeStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.outputStream = null;
    }
}

