/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.DoubleUtils;
import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.Base64Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.HexBinary;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNullValueException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.VariantGeneric;
import com.tplus.transform.runtime.collection.ValueList;
import com.tplus.transform.runtime.formula.BinaryFunctions;
import com.tplus.transform.util.CalendarFormatter;
import com.tplus.transform.util.CalendarParser;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Parsing {
    static ThreadLocal dateFormatCacheLocal = new ThreadLocal();
    public static final String ISO_DATE_TIME_FORMAT = DesignerType.DESIGNER_ISO_DATE_TIME_TYPE.getDefaultFormat();
    public static final String ISO_DATE_FORMAT = DesignerType.DESIGNER_ISO_DATE_TYPE.getDefaultFormat();
    public static final String ISO_TIME_FORMAT = DesignerType.DESIGNER_ISO_TIME_TYPE.getDefaultFormat();
    public static final String ISO_DATE_TIME_FORMAT_NO_TZ = DesignerType.DESIGNER_DATE_TIME_TYPE.getDefaultFormat();
    public static final String ISO_DATE_FORMAT_NO_TZ = DesignerType.DESIGNER_DATE_ONLY_TYPE.getDefaultFormat();
    public static final String ISO_TIME_FORMAT_NO_TZ = DesignerType.DESIGNER_TIME_ONLY_TYPE.getDefaultFormat();
    public static final String SIMPLE_DATE_FORMAT = "yyyyMMdd";
    public static final String SIMPLE_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String SIMPLE_DATE_TIME_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";
    static DecimalFormat decimalFormat = new DecimalFormat();
    public static final DoubleUtils.NumberFormatInfo DEFAULT_NUMBER_FORMAT;

    static Map getDateFormatCache() {
        HashMap dateFormatCache = (HashMap)dateFormatCacheLocal.get();
        if (dateFormatCache == null) {
            dateFormatCache = new HashMap();
            dateFormatCacheLocal.set(dateFormatCache);
        }
        return dateFormatCache;
    }

    public static DateFormat getDateFormat(String pattern) {
        Map dateFormatCache = Parsing.getDateFormatCache();
        SimpleDateFormat dateFormat = (SimpleDateFormat)dateFormatCache.get(pattern);
        if (dateFormat == null) {
            try {
                pattern = pattern.intern();
                dateFormat = new SimpleDateFormat(pattern);
                dateFormat.setLenient(false);
                dateFormatCache.put(pattern, dateFormat);
            }
            catch (IllegalArgumentException e) {
                TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT451");
                tre.setDetail(e);
                throw tre;
            }
        }
        return dateFormat;
    }

    public static Object toStringTypeObject(Object obj) throws TransformException {
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof RawMessage) {
            return ((RawMessage)obj).getAsString();
        }
        return obj;
    }

    public static Object toBinaryTypeObject(Object obj) throws TransformException {
        if (obj instanceof byte[]) {
            return obj;
        }
        if (obj instanceof InputSource) {
            return ((InputSource)obj).getAsBytes();
        }
        return obj;
    }

    public static Object toRawMessageTypeObject(Object obj) {
        if (obj instanceof RawMessage) {
            return obj;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputSource((byte[])obj);
        }
        if (obj instanceof String) {
            return new StringInputSource((String)obj);
        }
        return obj;
    }

    public static Variant toObjectTypeObject(Object obj) {
        if (obj instanceof Variant) {
            return (Variant)obj;
        }
        return new VariantGeneric(obj);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        if (Parsing.isISOPattern(pattern)) {
            return CalendarFormatter.format(pattern, date);
        }
        DateFormat formatter = Parsing.getDateFormat(pattern);
        String formattedString = formatter.format(date);
        return formattedString;
    }

    public static String formatISODateOnly(Calendar date) {
        return Parsing.formatISODate(date, ISO_DATE_FORMAT);
    }

    public static String formatISOTimeOnly(Calendar date) {
        return Parsing.formatISODate(date, ISO_TIME_FORMAT);
    }

    public static String formatDateOnly(Date date) {
        return Parsing.formatDate(date, ISO_DATE_FORMAT);
    }

    public static String formatTimeOnly(Date date) {
        return Parsing.formatDate(date, ISO_TIME_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return Parsing.formatDate(date, ISO_DATE_TIME_FORMAT);
    }

    public static Calendar parseISODateOnly(String arg) throws FieldParsingException {
        return Parsing.parseISODate(arg, ISO_DATE_FORMAT);
    }

    public static Calendar parseISOTimeOnly(String arg) throws FieldParsingException {
        return Parsing.parseISODate(arg, ISO_TIME_FORMAT);
    }

    public static Date parseDateOnly(String arg) throws FieldParsingException {
        return CalendarParser.parseAsDate(ISO_DATE_FORMAT, arg);
    }

    public static Date parseTimeOnly(String arg) throws FieldParsingException {
        return CalendarParser.parseAsDate(ISO_TIME_FORMAT, arg);
    }

    public static Date parseDateTime(String arg) throws FieldParsingException {
        return CalendarParser.parseAsDate(ISO_DATE_TIME_FORMAT, arg);
    }

    public static Date parseDate(String arg, String pattern) throws FieldParsingException {
        try {
            if (Parsing.isISOPattern(pattern)) {
                return CalendarParser.parseAsDate(pattern, arg);
            }
            ParsePosition pos = new ParsePosition(0);
            DateFormat df = Parsing.getDateFormat(pattern);
            Date date = df.parse(arg, pos);
            if (date == null) {
                return Parsing.conversionError(arg, pattern);
            }
            if (pos.getIndex() != arg.length()) {
                Parsing.conversionError(arg, pattern);
            }
            return date;
        }
        catch (IllegalArgumentException illArg) {
            Parsing.conversionError(arg, pattern);
        }
        catch (Exception parse) {
            Parsing.conversionError(arg, pattern);
        }
        return null;
    }

    private static Date conversionError(String arg, String pattern) throws FieldParsingException {
        throw FieldParsingException.createFieldParsingExceptionFormatted("SRT120", new Object[]{arg, pattern});
    }

    public static Calendar parseISODate(String str, String format) throws FieldParsingException {
        try {
            return CalendarParser.parse(format, str);
        }
        catch (IllegalArgumentException illArg) {
            Parsing.conversionError(str, format);
            return null;
        }
    }

    public static ValueList parseList(String str, DesignerType designerType) throws TransformException {
        return (ValueList)designerType.parse(str);
    }

    public static double parseDouble(String arg) throws FieldParsingException {
        try {
            return Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_DOUBLE_TYPE});
        }
    }

    public static int parseInt(String arg) throws FieldParsingException {
        try {
            return Wrapper.parseInt(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_INT_TYPE});
        }
    }

    public static long parseLong(String arg) throws FieldParsingException {
        try {
            return Wrapper.parseLong(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_LONG_TYPE});
        }
    }

    public static BigInteger parseBigInteger(String arg) throws FieldParsingException {
        try {
            return Wrapper.parseBigInteger(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_BIG_INT_TYPE});
        }
    }

    public static BigDecimal parseBigDecimal(String arg) throws FieldParsingException {
        try {
            return Wrapper.toBigDecimal(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_BIG_DECIMAL_TYPE});
        }
    }

    public static BigDecimal toBigDecimal(String arg) throws FieldParsingException {
        return Parsing.parseBigDecimal(arg);
    }

    public static BigDecimal toBigDecimal(int arg) throws FieldParsingException {
        return Wrapper.toBigDecimal(arg);
    }

    public static BigDecimal toBigDecimal(double arg) throws FieldParsingException {
        return Wrapper.toBigDecimal(arg);
    }

    public static ScaledDecimal parseScaledDecimal(String arg) throws FieldParsingException {
        try {
            return new ScaledDecimal(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_SCALED_DECIMAL_TYPE});
        }
    }

    public static byte[] parseBinary(String arg) throws FieldParsingException {
        try {
            return Parsing.hexStringToBinary(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_BINARY_TYPE});
        }
    }

    public static boolean parseBoolean(String arg) throws FieldParsingException {
        if (arg.equalsIgnoreCase("true")) {
            return true;
        }
        if (arg.equalsIgnoreCase("false")) {
            return false;
        }
        if (arg.equals("1")) {
            return true;
        }
        if (arg.equals("0")) {
            return false;
        }
        throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_BOOLEAN_TYPE});
    }

    public static float parseFloat(String arg) throws FieldParsingException {
        try {
            return Float.parseFloat(arg);
        }
        catch (NumberFormatException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_FLOAT_TYPE});
        }
    }

    public static char parseChar(String arg) throws FieldParsingException {
        if (arg.length() == 1) {
            return arg.charAt(0);
        }
        throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{arg, DesignerType.DESIGNER_CHAR_TYPE});
    }

    public static int intValue(Number number) {
        Parsing.ensureNotNull(number);
        return number.intValue();
    }

    public static long longValue(Number number) {
        Parsing.ensureNotNull(number);
        return number.longValue();
    }

    public static BigInteger bigIntegerValue(Number number) {
        Parsing.ensureNotNull(number);
        return (BigInteger)number;
    }

    private static void ensureNotNull(Object number) {
        if (number == null) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT133");
        }
    }

    public static BigDecimal bigDecimalValue(Number number) {
        Parsing.ensureNotNull(number);
        return (BigDecimal)number;
    }

    public static ScaledDecimal scaledDecimalValue(Number number) {
        Parsing.ensureNotNull(number);
        return (ScaledDecimal)number;
    }

    public static double doubleValue(Number number) {
        Parsing.ensureNotNull(number);
        return number.doubleValue();
    }

    public static float floatValue(Number number) {
        Parsing.ensureNotNull(number);
        return number.floatValue();
    }

    public static char charValue(Character charVal) {
        Parsing.ensureNotNull(charVal);
        return charVal.charValue();
    }

    public static boolean booleanValue(Boolean boolVal) {
        Parsing.ensureNotNull(boolVal);
        return boolVal;
    }

    public static int intValueWithNull(Number number) {
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public static long longValueWithNull(Number number) {
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    public static BigInteger bigIntegerValueWithNull(Number number) {
        return (BigInteger)number;
    }

    public static BigDecimal bigDecimalValueWithNull(Number number) {
        return (BigDecimal)number;
    }

    public static ScaledDecimal scaledDecimalValueWithNull(Number number) {
        return (ScaledDecimal)number;
    }

    public static double doubleValueWithNull(Number number) {
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public static float floatValueWithNull(Number number) {
        if (number == null) {
            return 0.0f;
        }
        return number.floatValue();
    }

    public static char charValueWithNull(Character charVal) {
        if (charVal == null) {
            return '\u0000';
        }
        return charVal.charValue();
    }

    public static boolean booleanValueWithNull(Boolean boolVal) {
        if (boolVal == null) {
            return false;
        }
        return boolVal;
    }

    public static String runtimeObjectToString(Object obj, DesignerType designerType) {
        if (designerType == null) {
            return obj.toString();
        }
        return designerType.format(obj);
    }

    public static String runtimeObjectToString(Object obj, String type) {
        if (type == null) {
            return null;
        }
        return Parsing.runtimeObjectToString(obj, DesignerType.valueOf(type));
    }

    public static boolean hasTimePart(Date date) {
        return date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0;
    }

    public static boolean hasDatePart(Date date) {
        return date.getYear() != 70 || date.getMonth() > 0 || date.getDate() > 1;
    }

    static String formatBigInteger(BigInteger value) {
        return value.toString();
    }

    static String formatBigDecimal(BigDecimal value) {
        return Parsing.toString(value);
    }

    static String formatBigDecimal(BigDecimal value, String format) {
        return Parsing.toString(value, format);
    }

    static String formatScaledDecimal(ScaledDecimal value) {
        return value.toString();
    }

    static String formatBinary(byte[] value) {
        return Parsing.binaryToHexString(value);
    }

    public static String formatISODateTime(Date date) {
        return CalendarFormatter.format(ISO_DATE_TIME_FORMAT_NO_TZ, date);
    }

    static String formatISODate(Date date) {
        return CalendarFormatter.format(ISO_DATE_FORMAT_NO_TZ, date);
    }

    static String formatISOTime(Date date) {
        return CalendarFormatter.format(ISO_TIME_FORMAT_NO_TZ, date);
    }

    static Date parseISOTimeAsDate(String str) {
        return CalendarParser.parseAsDate(ISO_TIME_FORMAT, str);
    }

    static Date parseISODateTimeAsDate(String str) {
        return CalendarParser.parseAsDate(ISO_DATE_TIME_FORMAT, str);
    }

    static Date parseISODateAsDate(String str) {
        return CalendarParser.parseAsDate(ISO_DATE_FORMAT, str);
    }

    public static String formatISODateTime(Calendar date) {
        return CalendarFormatter.format(ISO_DATE_TIME_FORMAT, date);
    }

    public static String toString(Calendar date) {
        return Parsing.formatISODateTime(date);
    }

    public static String formatISODate(Calendar date) {
        return CalendarFormatter.format(ISO_DATE_FORMAT, date);
    }

    static String formatISOTime(Calendar date) {
        return CalendarFormatter.format(ISO_TIME_FORMAT, date);
    }

    public static String formatISODate(Calendar date, String format) {
        if (Parsing.isISOPattern(format)) {
            return CalendarFormatter.format(format, date);
        }
        DateFormat df = Parsing.getDateFormat(format);
        String formattedString = df.format(date.getTime());
        return formattedString;
    }

    public static boolean isISOPattern(String pattern) {
        return pattern.indexOf(37) != -1;
    }

    static Calendar parseISOTime(String str) throws FieldParsingException {
        try {
            return CalendarParser.parse(ISO_TIME_FORMAT, str);
        }
        catch (IllegalArgumentException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT120", str, ISO_TIME_FORMAT);
        }
    }

    public static Calendar parseISODateTime(String str) throws FieldParsingException {
        try {
            return CalendarParser.parse(ISO_DATE_TIME_FORMAT, str);
        }
        catch (IllegalArgumentException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT120", str, ISO_DATE_TIME_FORMAT);
        }
    }

    static Calendar parseISODate(String str) throws FieldParsingException {
        try {
            return CalendarParser.parse(ISO_DATE_FORMAT, str);
        }
        catch (IllegalArgumentException e) {
            throw FieldParsingException.createFieldParsingExceptionFormatted("SRT120", str, ISO_DATE_FORMAT);
        }
    }

    public static Object toRuntimeObject(Object obj, String type) throws TransformException {
        return Parsing.toRuntimeObject(obj, DesignerType.valueOf(type));
    }

    public static Object toRuntimeObject(Object obj, DesignerType type) throws TransformException {
        return Parsing.toRuntimeObject(obj, type, false);
    }

    public static Object toRuntimeObject(Object obj, DesignerType designerType, boolean strict) throws TransformException {
        try {
            if (obj == null) {
                return null;
            }
            if (!strict && obj instanceof String && ((String)obj).length() == 0) {
                return null;
            }
            if (designerType == DesignerTypes.STRING_TYPE) {
                if (obj instanceof String) {
                    return obj;
                }
                return obj.toString();
            }
            if (designerType == DesignerTypes.INT_TYPE) {
                if (obj instanceof String) {
                    return Wrapper.box(Wrapper.parseInt((String)obj));
                }
                if (obj instanceof Number) {
                    return Wrapper.box(((Number)obj).intValue());
                }
            } else if (designerType == DesignerTypes.LONG_TYPE) {
                if (obj instanceof String) {
                    return Wrapper.box(Wrapper.parseLong((String)obj));
                }
                if (obj instanceof Number) {
                    return Wrapper.box(((Number)obj).longValue());
                }
            } else if (designerType == DesignerTypes.BIG_INTEGER_TYPE) {
                if (obj instanceof String) {
                    return new BigInteger((String)obj);
                }
                if (obj instanceof BigInteger) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return BigInteger.valueOf(((Number)obj).longValue());
                }
            } else if (designerType == DesignerTypes.BIG_DECIMAL_TYPE) {
                if (obj instanceof String) {
                    return new BigDecimal((String)obj);
                }
                if (obj instanceof BigDecimal) {
                    return obj;
                }
                if (obj instanceof Double || obj instanceof Float) {
                    return new BigDecimal(((Number)obj).doubleValue());
                }
                if (obj instanceof Number) {
                    return new BigDecimal(((Number)obj).longValue());
                }
            } else if (designerType == DesignerTypes.SCALED_DECIMAL_TYPE) {
                if (obj instanceof String) {
                    return new ScaledDecimal((String)obj);
                }
                if (obj instanceof ScaledDecimal) {
                    return obj;
                }
                if (obj instanceof Double || obj instanceof Float) {
                    return new ScaledDecimal(((Number)obj).doubleValue());
                }
                if (obj instanceof Number) {
                    return new ScaledDecimal(((Number)obj).longValue());
                }
            } else if (designerType == DesignerTypes.BINARY_TYPE) {
                if (obj instanceof String) {
                    String str = (String)obj;
                    return BinaryFunctions.toASCIIBinary(str);
                }
                if (obj instanceof byte[]) {
                    return obj;
                }
            } else if (designerType == DesignerTypes.RAW_MESSAGE_TYPE) {
                if (obj instanceof String) {
                    String str = (String)obj;
                    return new StringInputSource(str);
                }
                if (obj instanceof byte[]) {
                    return new ByteArrayInputSource((byte[])obj);
                }
            } else if (designerType == DesignerTypes.FLOAT_TYPE) {
                if (obj instanceof String) {
                    return new Float(Float.parseFloat((String)obj));
                }
                if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                }
            } else if (designerType == DesignerTypes.DOUBLE_TYPE) {
                if (obj instanceof String) {
                    return new Double(Double.parseDouble((String)obj));
                }
                if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                }
            } else {
                if (designerType == DesignerTypes.DATE_TIME_TYPE && obj instanceof String) {
                    String dateStr = (String)obj;
                    if (dateStr.length() == 0) {
                        return null;
                    }
                    String format = SIMPLE_DATE_FORMAT;
                    if (dateStr.indexOf(58) != -1) {
                        format = SIMPLE_TIME_FORMAT;
                        if (dateStr.indexOf(45) != -1) {
                            format = SIMPLE_DATE_TIME_FORMAT;
                        }
                    }
                    try {
                        return Parsing.parseDate(dateStr, format);
                    }
                    catch (FieldParsingException parse) {
                        return Parsing.parseDate(dateStr, SIMPLE_DATE_FORMAT);
                    }
                }
                if (designerType == DesignerTypes.DATE_ONLY_TYPE && obj instanceof String) {
                    String dateStr = (String)obj;
                    if (dateStr.length() == 0) {
                        return null;
                    }
                    String format = SIMPLE_DATE_FORMAT;
                    return Parsing.parseDate(dateStr, format);
                }
                if (designerType == DesignerTypes.TIME_ONLY_TYPE && obj instanceof String) {
                    String dateStr = (String)obj;
                    if (dateStr.length() == 0) {
                        return null;
                    }
                    String format = SIMPLE_TIME_FORMAT;
                    return Parsing.parseDate(dateStr, format);
                }
                if (designerType == DesignerTypes.ISO_DATE_TIME_TYPE) {
                    if (obj instanceof String) {
                        String dateStr = (String)obj;
                        return Parsing.parseISODateTime(dateStr);
                    }
                } else if (designerType == DesignerTypes.ISO_DATE_TYPE) {
                    if (obj instanceof String) {
                        String dateStr = (String)obj;
                        return Parsing.parseISODate(dateStr);
                    }
                } else if (designerType == DesignerTypes.ISO_TIME_TYPE) {
                    if (obj instanceof String) {
                        String dateStr = (String)obj;
                        return Parsing.parseISOTime(dateStr);
                    }
                } else if (designerType == DesignerTypes.BOOLEAN_TYPE) {
                    if (obj instanceof String) {
                        return Parsing.parseBoolean((String)obj) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (obj instanceof Boolean) {
                        return obj;
                    }
                } else if (designerType == DesignerTypes.CHAR_TYPE) {
                    if (obj instanceof String) {
                        String str = (String)obj;
                        if (str.length() == 0) {
                            return null;
                        }
                        if (str.length() == 1) {
                            return new Character(str.charAt(0));
                        }
                    }
                    if (obj instanceof Character) {
                        return obj;
                    }
                }
            }
        }
        catch (NumberFormatException e) {
        }
        catch (FieldParsingException fieldParsingException) {
            // empty catch block
        }
        throw FieldParsingException.createFieldParsingExceptionFormatted("SRT127", new Object[]{obj, designerType});
    }

    public static final String toString(int val) {
        return Wrapper.toString(val);
    }

    public static final String toString(long val) {
        return Long.toString(val);
    }

    public static final String toString(BigInteger val) {
        return val.toString();
    }

    public static String toString(BigDecimal val) {
        return Wrapper.toString(val);
    }

    public static String toString(BigDecimal val, String format) {
        return Wrapper.toString(val, format);
    }

    public static String toString(ScaledDecimal val) {
        return val.toString();
    }

    public static String toString(byte[] val) {
        return Parsing.binaryToHexString(val);
    }

    public static String toText(Variant val) {
        return val.toText();
    }

    public static int toInt(Variant val) {
        return val.toInt();
    }

    public static long toLong(Variant val) {
        return val.toLong();
    }

    public static float toFloat(Variant val) {
        return val.toFloat();
    }

    public static double toDouble(Variant val) {
        return val.toDouble();
    }

    public static Date toDate(Variant val) {
        return val.toDate();
    }

    public static Calendar toISODate(Variant val) {
        return val.toISODate();
    }

    public static boolean toBoolean(Variant val) {
        return val.toBoolean();
    }

    public static RawMessage toRawMessage(Variant val) {
        return val.toRawMessage();
    }

    public static BigDecimal toBigDecimal(Variant val) {
        return val.toBigDecimal();
    }

    public static ScaledDecimal toScaledDecimalDecimal(Variant val) {
        return val.toScaledDecimal();
    }

    public static BigInteger toBigInteger(Variant val) {
        return val.toBigInteger();
    }

    public static byte[] toBinary(Variant val) {
        return val.toBinary();
    }

    public static DataObjectSection getSection(Variant val) {
        return val.getSection();
    }

    public static ValueList toList(Variant val) {
        return val.toList();
    }

    public static Variant nullVariant(DesignerType type) {
        return new VariantGeneric(type);
    }

    public static Variant toVariant(String value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(char value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Character value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(int value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Integer value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(long value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Long value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(double value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Double value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(float value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Float value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(BigInteger value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(BigDecimal value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(boolean value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Boolean value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(ScaledDecimal value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Date value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Calendar value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(Object value, DesignerType designerType) {
        return new VariantGeneric(value, designerType);
    }

    public static Variant toVariant(Object value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(ValueList value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(RawMessage value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(byte[] value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(DataObject value) {
        return new VariantGeneric(value);
    }

    public static Variant toVariant(DataObjectSection value) {
        return new VariantGeneric(value);
    }

    public static String toObject(String value) {
        return value;
    }

    public static Character toObject(char value) {
        return Wrapper.box(value);
    }

    public static Integer toObject(int value) {
        return Wrapper.box(value);
    }

    public static Long toObject(long value) {
        return Wrapper.box(value);
    }

    public static Double toObject(double value) {
        return Wrapper.box(value);
    }

    public static Float toObject(float value) {
        return Wrapper.box(value);
    }

    public static BigInteger toObject(BigInteger value) {
        return value;
    }

    public static BigDecimal toObject(BigDecimal value) {
        return value;
    }

    public static Boolean toObject(boolean value) {
        return Wrapper.box(value);
    }

    public static ScaledDecimal toObject(ScaledDecimal value) {
        return value;
    }

    public static Date toObject(Date value) {
        return value;
    }

    public static Calendar toObject(Calendar value) {
        return value;
    }

    public static ValueList toObject(ValueList value) {
        return value;
    }

    public static RawMessage toObject(RawMessage value) {
        return value;
    }

    public static byte[] toObject(byte[] value) {
        return value;
    }

    public static DataObject toObject(DataObject value) {
        return value;
    }

    public static DataObjectSection toObject(DataObjectSection value) {
        return value;
    }

    public static String toString(double val) {
        return DoubleUtils.toString(val, DEFAULT_NUMBER_FORMAT);
    }

    public static String toString(float val) {
        return DoubleUtils.toString(val, DEFAULT_NUMBER_FORMAT);
    }

    public static String toString(boolean val) {
        return val ? "true" : "false";
    }

    public static String toString(char val) {
        return new String(new char[]{val});
    }

    public static String toString(Date val) {
        return val.toString();
    }

    public static String toString(String val) {
        return val;
    }

    public static String binaryToBase64String(byte[] binary) {
        return Base64Binary.fromBinary(binary);
    }

    public static byte[] base64StringToBinary(String str) throws FieldParsingException {
        return Base64Binary.toBinary(str);
    }

    public static String binaryToHexString(byte[] binary) {
        return HexBinary.fromBinary(binary);
    }

    public static byte[] hexStringToBinary(String str) throws FieldParsingException {
        return HexBinary.toBinary(str);
    }

    public static byte[] asciiStringToBinary(String str) {
        try {
            return CharBinaryBuffer.stringToBytes(str, "ascii");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static void cmtmain(String[] args) throws FieldParsingException {
        Parsing.parseDate("2011-02-10-10:29:40", "yyyy-MM-dd-HH:mm:SS");
    }

    static void reverseTest(String str) throws FieldParsingException {
        byte[] bytes = Parsing.hexStringToBinary(str);
        String newStr = Parsing.binaryToHexString(bytes);
        System.out.println("Input Str = " + str);
        System.out.println("bytes = " + Parsing.byteToString(bytes));
        System.out.println("Output Str = " + newStr);
        if (!newStr.equals(str)) {
            System.out.println("FAILED");
        }
    }

    static String byteToString(byte[] bytes) {
        FastStringBuffer toRet = new FastStringBuffer(bytes.length * 2 + 10);
        for (int i = 0; i < bytes.length; ++i) {
            toRet.append(bytes[i]);
            toRet.append(",");
        }
        return toRet.toString();
    }

    public static boolean equal(Boolean val1, Boolean val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.booleanValue() == val2.booleanValue();
    }

    public static boolean equal(Character val1, Character val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.charValue() == val2.charValue();
    }

    public static boolean equal(Double val1, Double val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.doubleValue() == val2.doubleValue();
    }

    public static boolean equal(Float val1, Float val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.doubleValue() == val2.doubleValue();
    }

    public static boolean equal(Long val1, Long val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.longValue() == val2.longValue();
    }

    public static boolean equal(Integer val1, Integer val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.equals(val2);
    }

    public static boolean equal(Number val1, Number val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        return val1.doubleValue() == val2.doubleValue();
    }

    static {
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(25);
        DEFAULT_NUMBER_FORMAT = new DoubleUtils.NumberFormatInfo();
        DEFAULT_NUMBER_FORMAT.setMaxDigits(20);
        DEFAULT_NUMBER_FORMAT.setDecimalPoint('.');
        DEFAULT_NUMBER_FORMAT.setAlwaysUseDecimalPoint(true);
        DEFAULT_NUMBER_FORMAT.setAlwaysUseDecimalComponent(true);
    }
}

