/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DBDialect;
import com.tplus.transform.runtime.TransformSQLException;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

class PersistenceSession {
    Connection connection;
    ConnectionPool connectionPool;
    Map statements = new SequencedHashMap();
    int batchSize;
    private Log log;
    boolean sqlError = false;
    DBDialect dialect;

    public PersistenceSession(Connection connection, int batchSize, DBDialect dialect, Log log) {
        this.connection = connection;
        this.batchSize = batchSize;
        this.dialect = dialect;
        this.log = log;
    }

    protected PreparedStatement createPreparedStatement(String sql) throws SQLException {
        StatementInfo stmtInfo = (StatementInfo)this.statements.get(sql);
        if (stmtInfo == null) {
            try {
                stmtInfo = new StatementInfo(sql);
                this.statements.put(sql, stmtInfo);
            }
            catch (SQLException e) {
                this.sqlError = true;
                throw e;
            }
        }
        return stmtInfo.getPreparedStatement();
    }

    protected void executeInsert(PreparedStatement ps, String sqlCommand) throws SQLException {
        StatementInfo statementInfo = this.findStatement(ps);
        statementInfo.executeInsert();
    }

    protected void flush(PreparedStatement ps) throws TransformSQLException, SQLException {
        StatementInfo statementInfo = this.findStatement(ps);
        statementInfo.finish();
    }

    protected void flush(String sql) throws SQLException {
        StatementInfo statementInfo = this.findStatement(sql);
        if (statementInfo != null) {
            statementInfo.finish();
        }
    }

    public DBDialect getDialect() {
        return this.dialect;
    }

    private StatementInfo findStatement(String sql) {
        return (StatementInfo)this.statements.get(sql);
    }

    StatementInfo findStatement(PreparedStatement ps) {
        for (StatementInfo statementInfo : this.statements.values()) {
            if (statementInfo.getPreparedStatement() != ps) continue;
            return statementInfo;
        }
        return null;
    }

    protected int executeUpdate(PreparedStatement ps, String sqlCommand) throws TransformSQLException {
        try {
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT643", e.getMessage());
            tsqle.setStatement(sqlCommand);
            tsqle.setDetail(e);
            throw tsqle;
        }
    }

    public void finishSession() throws SQLException {
        for (StatementInfo statementInfo : this.statements.values()) {
            statementInfo.finish();
        }
    }

    public void closeSession() throws SQLException {
        for (StatementInfo statementInfo : this.statements.values()) {
            statementInfo.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closePreparedStatement(PreparedStatement ps) {
    }

    class StatementInfo {
        String sql;
        PreparedStatement preparedStatement;
        int batchCount;

        public StatementInfo(String sql) throws SQLException {
            this.sql = sql;
            this.preparedStatement = PersistenceSession.this.connection.prepareStatement(sql);
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public int getBatchCount() {
            return this.batchCount;
        }

        public void executeInsert() throws SQLException {
            if (PersistenceSession.this.batchSize == 1) {
                this.preparedStatement.executeUpdate();
                this.batchCount = 0;
            } else {
                if (this.getBatchCount() < PersistenceSession.this.batchSize) {
                    this.preparedStatement.addBatch();
                    ++this.batchCount;
                }
                if (this.getBatchCount() >= PersistenceSession.this.batchSize) {
                    this.finish();
                }
            }
        }

        public void close() throws SQLException {
            this.preparedStatement.close();
        }

        public void finish() throws SQLException {
            if (this.getBatchCount() > 0) {
                PersistenceSession.this.log.debug("Executing batch (count = " + this.batchCount + ") : " + this.sql);
                this.preparedStatement.executeBatch();
            }
            this.batchCount = 0;
        }
    }
}

